/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.IOFunctions;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.io.FileUtil;
import com.github.jlangch.venice.impl.util.shell.ShellResult;
import com.github.jlangch.venice.impl.util.shell.Signal;
import com.github.jlangch.venice.impl.util.shell.SimpleShell;
import com.github.jlangch.venice.impl.util.shell.SmartShell;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ShellFunctions {
    public static VncFunction sh = new VncFunction("sh", (VncVal)VncFunction.meta().arglists("(sh & args)").doc("Launches a new sub-process.\n\nOptions:\n\n| :in       | may be given followed by input source as InputStream,               Reader, File, ByteBuf, or String, to be fed to the               sub-process's stdin. |\n| :in-enc   | option may be given followed by a String, used as a               character encoding name (for example \"UTF-8\" or               \"ISO-8859-1\") to convert the input string specified               by the :in option to the sub-process's stdin. Defaults               to \"UTF-8\". If the :in option provides a byte array,               then the bytes are passed unencoded, and this option               is ignored. |\n| :out-enc  | option may be given followed by :bytes or a String. If               a String is given, it will be used as a character               encoding name (for example \"UTF-8\" or \"ISO-8859-1\")               to convert the sub-process's stdout to a String which is               returned. If :bytes is given, the sub-process's stdout               will be stored in a Bytebuf and returned. Defaults to               UTF-8. |\n| :out-fn   | a function with a single string argument that receives               line by line from the process' stdout. If passed the               :out value in the return map will be empty. |\n| :err-fn   | a function with a single string argument that receives               line by line from the process' stderr. If passed the               :err value in the return map will be empty. |\n| :env      | override the process env with a map. |\n| :dir      | override the process dir with a String or java.io.File. |\n| :throw-ex | If true throw an exception if the exit code is not equal               to zero, if false returns the exit code. Defaults to               false.\u00b6              It's recommended to use\u00b6              &emsp; `(with-sh-throw (sh \"ls\" \"-l\"))` \u00b6              instead. |\n| :timeout  | A timeout in milliseconds |\n\n```                                                                  \n   +---------------------------------------------------------+       \n   |                       Venice Script                     |       \n   +---------------------------------------------------------+       \n      |                         |                         ^          \n      | supply                  | run                     | consume  \n      v                         v                         |          \n+---------+      +----------------------------+           |          \n| in-data |----->|stdin                       |      +----------+    \n+---------+      |       SHELL PROCESS  stdout|----->|  out-fn  |    \n                 |                      stderr|----->|  err-fn  |    \n                 +----------------------------+      +----------+    \n```                                                                  \n\nYou can bind :env, :dir for multiple operations using `with-sh-env` or `with-sh-dir`. `with-sh-throw` is binds *:throw-ex* as *true*.\n\n`sh` returns a map of:\n\n```                                                                  \n:exit => sub-process's exit code                                     \n:out  => sub-process's stdout (as Bytebuf or String)                 \n:err  => sub-process's stderr (String via platform default encoding) \n```\n\nE.g.:\n\n```                                       \n(sh \"uname\" \"-r\")                     \n=> {:err \"\" :out \"20.5.0\\n\" :exit 0} \n```").examples("(println (sh \"ls\" \"-l\"))", "(println (sh \"ls\" \"-l\" \"/tmp\"))", "(println (sh \"sed\" \"s/[aeiou]/oo/g\" :in \"hello there\\n\"))", "(println (sh \"cat\" :in \"x\\u25bax\\n\"))", "(println (sh \"echo\" \"x\\u25bax\"))", "(println (sh \"/bin/sh\" \"-c\" \"ls -l\"))", "(sh \"ls\" \"-l\" :out-fn println)", "(sh \"ls\" \"-l\" :out-fn println :err-fn println)", ";; background process\n(println (sh \"/bin/sh\" \"-c\" \"sleep 30 >/dev/null 2>&1 &\"))", "(println (sh \"/bin/sh\" \"-c\" \"nohup sleep 30 >/dev/null 2>&1 &\"))", ";; asynchronously slurping stdout and stderr\n(sh \"/bin/sh\" \n    \"-c\" \"for i in {1..5}; do sleep 1; echo \\\"Hello $i\\\"; done\" \n    :out-fn println \n    :err-fn println)", ";; asynchronously slurping stdout and stderr with a timeout\n(sh \"/bin/sh\" \n    \"-c\" \"for i in {1..5}; do sleep 1; echo \\\"Hello $i\\\"; done\" \n    :out-fn println \n    :err-fn println \n    :timeout 2500)", ";; reads 4 single-byte chars\n(println (sh \"echo\" \"x\\u25bax\" :out-enc \"ISO-8859-1\"))", ";; reads binary file into bytes[]\n(println (sh \"cat\" \"birds.jpg\" :out-enc :bytes))", ";; working directory\n(println (with-sh-dir \"/tmp\" (sh \"ls\" \"-l\") (sh \"pwd\")))", "(println (sh \"pwd\" :dir \"/tmp\"))", ";; throw an exception if the shell's subprocess exit code is not equal to 0\n(println (with-sh-throw (sh \"ls\" \"-l\")))", "(println (sh \"ls\" \"-l\" :throw-ex true))", ";; windows\n(println (sh \"cmd\" \"/c dir 1>&2\"))").seeAlso("with-sh-throw", "with-sh-dir", "with-sh-env").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncVector v = ShellFunctions.parseArgs(args);
            VncList cmd = Coerce.toVncList(v.first()).withMeta(args.getMeta());
            VncMap opts = Coerce.toVncMap(v.second()).withMeta(args.getMeta());
            return SmartShell.exec(cmd, opts, null);
        }
    };
    public static VncFunction open = new VncFunction("sh/open", (VncVal)VncFunction.meta().arglists("(sh/open f)").doc("Opens a *file* or an *URL* with the associated platform specific application. \n\nUses the OS commands:\n\n* *MacOS*: `/usr/bin/open f`\n* *Windows*: `cmd /C start f`\n* *Linux*: `/usr/bin/xdg-open f`\n\nNote: `sh/open` can only be run from a REPL!").examples("(sh/open \"sample.pdf\")", "(sh/open \"https://github.com/jlangch/venice\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            switch (SystemFunctions.osType()) {
                case "mac-osx": {
                    sh.apply(VncList.of(new VncString("/usr/bin/open"), args.first()));
                    break;
                }
                case "linux": {
                    sh.apply(VncList.of(new VncString("/usr/bin/xdg-open"), args.first()));
                    break;
                }
                case "windows": {
                    sh.apply(VncList.of(new VncString("cmd"), new VncString("/C"), new VncString("start"), args.first()));
                    break;
                }
                default: {
                    throw new VncException("Unsupported OS");
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction pwd = new VncFunction("sh/pwd", (VncVal)VncFunction.meta().arglists("(sh/pwd)").doc("Returns the current working directory.\n\nNote: \u00b6You can't change the current working directory of the Java VM but if you were to launch another process using (sh & args) you can specify the working directory for the new spawned process.").examples("(sh/pwd)").seeAlso("sh").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("user.dir")));
        }
    };
    public static VncFunction kill = new VncFunction("sh/kill", (VncVal)VncFunction.meta().arglists("(sh/kill pid)", "(sh/kill pid signal)").doc("Kills a process.\n\nThe signal to be sent is one of {:sighup, :sigint, :sigquit, :sigkill, :sigterm}. If no signal is specified, the :sigterm signal is sent.\n\nRuns the Unix command: `kill -signal {pid}`\n\nThrows an exception if the process does not exist or cannot be killed!\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/kill \"2345\")", "(sh/kill \"2345\" :sigkill)").seeAlso("sh", "sh/alive?", "sh/killall", "sh/pgrep", "sh/pkill", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/kill");
            String pid = Coerce.toVncString(args.first()).getValue();
            if (args.size() == 1) {
                SimpleShell.kill(pid, null);
            } else {
                SimpleShell.kill(pid, Signal.valueOf(Coerce.toVncKeyword(args.second()).getSimpleName().toUpperCase()));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction killall = new VncFunction("sh/killall", (VncVal)VncFunction.meta().arglists("(sh/killall name)", "(sh/killall name signal)").doc("Kills all processes with the given name.\n\nThe signal to be sent is one of {:sighup, :sigint, :sigquit, :sigkill, :sigterm}. If no signal is specified, the :sigterm signal is sent.\n\nRuns the Unix command: `killall -signal -e {name}`\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/killall \"clamd\")", "(sh/killall \"clamd\" :sigkill)").seeAlso("sh", "sh/alive?", "sh/kill", "sh/pgrep", "sh/pkill", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/killall");
            String name = Coerce.toVncString(args.first()).getValue();
            if (args.size() == 1) {
                SimpleShell.killall(name, null);
            } else {
                SimpleShell.killall(name, Signal.valueOf(Coerce.toVncKeyword(args.second()).getSimpleName().toUpperCase()));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction alive_Q = new VncFunction("sh/alive?", (VncVal)VncFunction.meta().arglists("(sh/alive? pid)").doc("Returns true if the process represented by the PID is alive otherwise false.\n\nRuns internally the Unix command `ps -p {pid}` to check if there is a process with the given pid.\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/alive? \"2345\")").seeAlso("sh", "sh/kill", "sh/killall", "sh/pgrep", "sh/pkill", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/alive?");
            VncVal arg1 = args.first();
            if (arg1 == Constants.Nil) {
                return VncBoolean.False;
            }
            String pid = Coerce.toVncString(arg1).getValue();
            ShellResult result = SimpleShell.execCmd("ps", "-p", pid);
            return VncBoolean.of(result.isZeroExitCode());
        }
    };
    public static VncFunction load_pid = new VncFunction("sh/load-pid", (VncVal)VncFunction.meta().arglists("(sh/load-pid pid-file)").doc("Load a process PID from a PID file.\n\nReturns the PID or `nil` if the file does not exist or is empty").examples("(sh/load-pid \"/data/scan.pid\")").seeAlso("sh", "sh/alive?", "sh/kill", "sh/killall", "sh/pgrep", "sh/pkill", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String s;
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'sh/load-pid' does not allow %s as f");
            SimpleShell.validateLinuxOrMacOSX("sh/load-pid");
            if (f.isFile() && (s = StringUtil.trimToNull(new String(FileUtil.load(f), Charset.forName("UTF-8")))) != null && s.matches("[0-9]+")) {
                return new VncString(s);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction pgrep = new VncFunction("sh/pgrep", (VncVal)VncFunction.meta().arglists("(sh/pgrep name)").doc("Returns a list of all pids for a process with the given name or `nil` if there are no processes matching the name.\n\nRuns the Unix command: `pgrep -x {name}`\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/pgrep \"clamd\")").seeAlso("sh", "sh/alive?", "sh/kill", "sh/killall", "sh/pkill", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/pgrep");
            String name = Coerce.toVncString(args.first()).getValue();
            List pids = SimpleShell.pgrep(name).stream().map(p -> new VncString((String)p)).collect(Collectors.toList());
            return VncList.ofList(pids);
        }
    };
    public static VncFunction pkill = new VncFunction("sh/pkill", (VncVal)VncFunction.meta().arglists("(sh/pkill name)", "(sh/pkill name signal)").doc("Sends a signal to all processes with the given name.\n\nThe signal to be sent is one of {:sighup, :sigint, :sigquit, :sigkill, :sigterm}.If no signal is specified, the :sigterm signal is sent.\n\nRuns the Unix command: `pkill -signal -x {name}`\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/pkill \"clamd\")", "(sh/pkill \"clamd\" :sigkill)").seeAlso("sh", "sh/alive?", "sh/kill", "sh/killall", "sh/pgrep", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/pkill");
            String name = Coerce.toVncString(args.first()).getValue();
            if (args.size() == 1) {
                SimpleShell.pkill(name, null);
            } else {
                SimpleShell.pkill(name, Signal.valueOf(Coerce.toVncKeyword(args.second()).getSimpleName().toUpperCase()));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction pargs = new VncFunction("sh/pargs", (VncVal)VncFunction.meta().arglists("(sh/pargs pid)", "(sh/pargs :parse pid)").doc("Returns a process' command line.\n\nWithout the `:parse` option returns the command line as a string or `nil` if there is no process matching the PID. With the `:parse` option returns a list of the command line arguments or an empty list the process does not exist.\n\nRuns the Unix command: `ps -p {pid} -ww -o args` to get the command line.\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/pargs \"1234\")", "(sh/pargs :parse \"1234\")").seeAlso("sh", "sh/alive?", "sh/kill", "sh/killall", "sh/pgrep", "sh/pkill").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/pargs");
            String pid = Coerce.toVncString(args.size() == 1 ? args.first() : args.second()).getValue();
            String flag = args.size() == 1 ? null : Coerce.toVncKeyword(args.first()).getValue();
            boolean parse = false;
            if (flag != null) {
                if (!flag.equals("parse")) {
                    throw new VncException("Invalid arguments for function 'sh/pargs'. Only :parse is supported as flag!");
                }
                parse = true;
            }
            String cmd = SimpleShell.pargs(pid);
            if (parse) {
                VncHashMap result = SmartShell.exec(VncList.of(new VncString("xargs"), new VncString("printf"), new VncString("%s\n")), VncHashMap.of(new VncKeyword("in"), new VncString(cmd)), null);
                long exitCode = ((VncLong)result.get(new VncKeyword(":exit"))).toJavaLong();
                if (exitCode != 0L) {
                    String err = ((VncString)result.get(new VncKeyword(":err"))).getValue();
                    throw new VncException("Function 'sh/pargs' failed with exit code " + exitCode + ". Error: " + err);
                }
                String out = ((VncString)result.get(new VncKeyword(":out"))).getValue();
                return VncList.ofColl(StringUtil.splitIntoLines(out).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
            }
            return StringUtil.isBlank(cmd) ? Constants.Nil : new VncString(cmd);
        }
    };
    public static VncFunction which = new VncFunction("sh/which", (VncVal)VncFunction.meta().arglists("(sh/which program)").doc("Locates a program's file in the user's path.\n\nReturns the program's full path or `nil` if not found.\n\nE.g. `(sh/which \"ps\")` returns /\"bin/ps\" for MacOSX and \"/usr/bin/ps\" for Linux RHEL variants.\n\nNote: This function is available for Linux and MacOS only!").examples("(sh/which \"ps\")").seeAlso("sh", "sh/alive?", "sh/kill", "sh/killall", "sh/pgrep", "sh/pargs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            SimpleShell.validateLinuxOrMacOSX("sh/which");
            String program = Coerce.toVncString(args.first()).getValue();
            String path = SimpleShell.which(program);
            return path == null ? Constants.Nil : new VncString(path);
        }
    };
    private static final VncHashSet optionKeywords = VncHashSet.of(new VncKeyword(":in"), new VncKeyword(":in-enc"), new VncKeyword(":out-enc"), new VncKeyword(":out-fn"), new VncKeyword(":err-fn"), new VncKeyword(":env"), new VncKeyword(":dir"), new VncKeyword(":throw-ex"), new VncKeyword(":timeout"));
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(sh).add(open).add(pwd).add(kill).add(killall).add(pgrep).add(pkill).add(pargs).add(which).add(alive_Q).add(load_pid).toMap();

    private static VncVector parseArgs(VncList args) {
        VncThreadLocal th = new VncThreadLocal();
        VncHashMap options = new VncHashMap();
        VncList cmd = VncList.empty();
        VncList args_ = args;
        while (!args_.isEmpty()) {
            VncVal v = args_.first();
            args_ = args_.rest();
            if (Types.isVncKeyword(v) && optionKeywords.contains(v)) {
                VncVal optVal = args_.first();
                args_ = args_.rest();
                options = options.assoc(v, optVal);
                continue;
            }
            cmd = cmd.addAtEnd(new VncString(v.toString()));
        }
        VncHashMap defaultOptions = VncHashMap.of(new VncKeyword(":out-enc"), new VncString("UTF-8"), new VncKeyword(":in-enc"), new VncString("UTF-8"), new VncKeyword(":dir"), th.get(":*sh-dir*"), new VncKeyword(":throw-ex"), th.get(":*sh-throw-ex*"));
        VncMap defaultEnv = (VncMap)th.get(":*sh-env*", (VncVal)new VncHashMap());
        VncMap opts = (VncMap)CoreFunctions.merge.apply(VncList.of(defaultOptions, options));
        opts = opts.assoc(new VncKeyword(":env"), CoreFunctions.merge.apply(VncList.of(defaultEnv, options.get(new VncKeyword(":env")))));
        return VncVector.of(cmd, opts);
    }
}

