/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.examples;

import com.github.jlangch.venice.IPreCompiled;
import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Embed_14_ExtensionPoint {
    public static void main(String[] args) {
        try {
            Embed_14_ExtensionPoint.run();
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public static void run() {
        Configuration config = new Configuration();
        config.setValue("audit.notification.filter", "(let [event-type  (. event :getType)                                \n      event-name  (. event :getName)                                \n      event-key   (. event :getKey)]                                \n  (or (match? event-name \"webapp[.](started|stopped)\")            \n      (and (== event-name \"login\") (== event-key \"superuser\"))  \n      (== (str event-type) \"ALERT\")                               \n      (str/starts-with? event-name \"login.foreign.country.\")))    ");
        NotificationService notficationService = new NotificationService();
        AuditNotifier notifier = new AuditNotifier(config, notficationService);
        notifier.refresh();
        notifier.process(new Event(EventType.INFO, "webapp.started", "system", "WebApp started"));
        notifier.process(new Event(EventType.INFO, "login", "john", "Login user john"));
        notifier.process(new Event(EventType.INFO, "order.save", "124656909", "Order created"));
        notifier.process(new Event(EventType.ALERT, "order.save", "124656909", "Failed to save order"));
        System.out.println("Notified events: " + notficationService.getSentEvents().size());
    }

    public static class Event {
        private final EventType type;
        private final String name;
        private final String key;
        private final String message;

        public Event(EventType type, String name, String key, String message) {
            this.type = type;
            this.name = name;
            this.key = key;
            this.message = message;
        }

        public EventType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.type.toString() + ", " + this.name + ", " + this.key + ", " + this.message;
        }
    }

    public static enum EventType {
        SYSTEM,
        INFO,
        WARN,
        ALERT;

    }

    public static class AuditNotifier {
        private final Configuration config;
        private final NotificationService notifSvc;
        private final Venice venice;
        private final AtomicReference<IPreCompiled> filter = new AtomicReference();

        public AuditNotifier(Configuration config, NotificationService notifSvc) {
            this.config = config;
            this.notifSvc = notifSvc;
            this.venice = new Venice(new SandboxRules().rejectAllUnsafeFunctions().withClasses("com.github.jlangch.venice.examples.*:*").whitelistVeniceFunctions(".").sandbox());
            this.filter.set(AuditNotifier.compileFilter(this.venice, config));
        }

        public void process(Event event) {
            Boolean match = (Boolean)this.venice.eval(this.filter.get(), Parameters.of("event", event));
            if (Boolean.TRUE.equals(match)) {
                this.notifSvc.sendAuditEventEmail(event);
            }
        }

        public void refresh() {
            this.filter.set(AuditNotifier.compileFilter(this.venice, this.config));
        }

        private static IPreCompiled compileFilter(Venice venice, Configuration config) {
            return venice.precompile("filter", config.getValue("audit.notification.filter"), true);
        }
    }

    public static class NotificationService {
        private List<Event> sentEvents = new ArrayList<Event>();

        public void sendAuditEventEmail(Event event) {
            this.sentEvents.add(event);
        }

        public List<Event> getSentEvents() {
            return Collections.unmodifiableList(this.sentEvents);
        }
    }

    public static class Configuration {
        private final HashMap<String, String> config = new HashMap();

        public String getValue(String key) {
            return this.config.get(key);
        }

        public void setValue(String key, String value) {
            this.config.put(key, value);
        }
    }
}

