/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class HexFormatter {
    private HexFormatter() {
    }

    public static String toHex(byte[] binary, String delimiter) {
        return HexFormatter.toHex(binary, delimiter, false);
    }

    public static String toHex(byte[] binary, String delimiter, boolean prefixWith0x) {
        return binary == null ? "" : IntStream.range(0, binary.length).mapToObj(idx -> HexFormatter.toHex(binary[idx], prefixWith0x)).collect(Collectors.joining(delimiter == null ? "" : delimiter));
    }

    public static String toHex(byte aByte) {
        return String.format("%02X", aByte);
    }

    public static String toHex(byte aByte, boolean prefixWith0x) {
        return prefixWith0x ? "0x" + HexFormatter.toHex(aByte) : HexFormatter.toHex(aByte);
    }
}

