/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.repackage.io.vavr.collection.Map;
import org.repackage.io.vavr.collection.SortedMap;
import org.repackage.io.vavr.collection.TreeMap;

public class VncSortedMap
extends VncMap {
    public static final String TYPE = ":core/sorted-map";
    private static final long serialVersionUID = -1848883965231344442L;
    private final TreeMap<VncVal, VncVal> value;

    public VncSortedMap() {
        this((Map<VncVal, VncVal>)null, null);
    }

    public VncSortedMap(VncVal meta) {
        this((Map<VncVal, VncVal>)null, meta);
    }

    public VncSortedMap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        this(null, wrappingTypeDef, meta);
    }

    public VncSortedMap(java.util.Map<? extends VncVal, ? extends VncVal> vals) {
        this(vals, null);
    }

    public VncSortedMap(java.util.Map<? extends VncVal, ? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : TreeMap.ofAll(vals), meta);
    }

    public VncSortedMap(Map<VncVal, VncVal> val, VncVal meta) {
        super(meta);
        this.value = val == null ? TreeMap.empty() : (val instanceof TreeMap ? (TreeMap)val : TreeMap.ofEntries(val));
    }

    public VncSortedMap(Map<VncVal, VncVal> val, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = val == null ? TreeMap.empty() : (val instanceof TreeMap ? (TreeMap)val : TreeMap.ofEntries(val));
    }

    public static VncSortedMap ofAll(VncSequence lst) {
        if (lst != null && lst.size() % 2 != 0) {
            throw new VncException(String.format("sorted-map: create requires an even number of list items. Got %d items.", lst.size()));
        }
        return new VncSortedMap().assoc(lst);
    }

    public static VncSortedMap ofAll(VncVector vec) {
        if (vec != null && vec.size() % 2 != 0) {
            throw new VncException(String.format("sorted-map: create requires an even number of vector items. Got %d items.", vec.size()));
        }
        return new VncSortedMap().assoc(vec);
    }

    public static VncSortedMap of(VncVal ... mvs) {
        if (mvs != null && mvs.length % 2 != 0) {
            throw new VncException(String.format("sorted-map: create requires an even number of items. Got %d items.", mvs.length));
        }
        return new VncSortedMap().assoc(mvs);
    }

    @Override
    public VncSortedMap emptyWithMeta() {
        return new VncSortedMap(this.getMeta());
    }

    @Override
    public VncSortedMap withValues(java.util.Map<VncVal, VncVal> replaceVals) {
        return new VncSortedMap(replaceVals, this.getMeta());
    }

    @Override
    public VncSortedMap withValues(java.util.Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncSortedMap(replaceVals, meta);
    }

    @Override
    public VncSortedMap withMeta(VncVal meta) {
        return new VncSortedMap(this.value, meta);
    }

    @Override
    public VncSortedMap wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncSortedMap(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/map"), new VncKeyword(":core/collection"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/map"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public java.util.Map<VncVal, VncVal> getJavaMap() {
        return Collections.unmodifiableMap(this.value.toJavaMap());
    }

    @Override
    public VncVal get(VncVal key) {
        return this.value.get(key).getOrElse(Constants.Nil);
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return VncBoolean.of(this.value.containsKey(key));
    }

    @Override
    public VncList keys() {
        return VncList.ofList(new ArrayList(this.value.keySet().toJavaList()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.value.map(e -> new VncMapEntry((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()));
    }

    @Override
    public VncSortedMap putAll(VncMap map) {
        if (map instanceof VncSortedMap) {
            return new VncSortedMap(this.value.merge(((VncSortedMap)map).value, (u, v) -> v), this.getMeta());
        }
        return new VncSortedMap(this.value.merge(TreeMap.ofAll(map.getJavaMap()), (u, v) -> v), this.getMeta());
    }

    @Override
    public VncSortedMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format("sorted-map: assoc requires an even number of items.", new Object[0]));
        }
        SortedMap<VncVal, VncVal> tmp = this.value;
        for (int i = 0; i < mvs.length - 1; i += 2) {
            tmp = tmp.put((Object)mvs[i], (Object)mvs[i + 1]);
        }
        return new VncSortedMap(tmp, this.getMeta());
    }

    @Override
    public VncSortedMap assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format("sorted-map: assoc requires an even number of items.", new Object[0]));
        }
        SortedMap<VncVal, VncVal> map = this.value;
        VncSequence kv = mvs;
        while (!kv.isEmpty()) {
            map = map.put((Object)kv.first(), (Object)kv.second());
            kv = kv.drop(2);
        }
        return new VncSortedMap(map, this.getMeta());
    }

    @Override
    public VncSortedMap dissoc(VncVal ... keys) {
        return new VncSortedMap(this.value.removeAll(Arrays.asList(keys)), this.getMeta());
    }

    @Override
    public VncSortedMap dissoc(VncSequence keys) {
        return new VncSortedMap(this.value.removeAll((Iterable)keys), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.SORTEDMAP;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSortedMap(o)) {
            int c = Integer.compare(this.size(), ((VncSortedMap)o).size());
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSortedMap other = (VncSortedMap)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        Stream<VncVal> stream = this.value.map(e -> Arrays.asList((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()).stream().flatMap(l -> l.stream());
        return "{" + Printer.join(stream, " ", print_machine_readably) + "}";
    }
}

