/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.IPreCompiled;
import com.github.jlangch.venice.IServiceRegistry;
import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.PreCompiled;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.ServiceRegistry;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.SymbolTable;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.ConcurrencyFunctions;
import com.github.jlangch.venice.impl.functions.ScheduleFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.namespaces.NamespaceRegistry;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.threadpool.ManagedCachedThreadPoolExecutor;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.concurrent.Agent;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.util.FunctionExecutionMeter;
import com.github.jlangch.venice.util.NullInputStream;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class Venice {
    private static ManagedCachedThreadPoolExecutor mngdExecutor = new ManagedCachedThreadPoolExecutor("venice-timeout-pool", 100);
    private long lastPrecompileElapsedTimeMillis = -1L;
    private final IInterceptor interceptor;
    private final MeterRegistry meterRegistry;
    private final IServiceRegistry serviceRegistry = new ServiceRegistry();
    private final AtomicReference<SymbolTable> coreSystemGlobalSymbols = new AtomicReference<Object>(null);
    private final PrintStream stdout = new PrintStream(System.out, true);
    private final PrintStream stderr = new PrintStream(System.err, true);
    private final Reader stdin = new InputStreamReader(System.in);

    public Venice() {
        this(null);
    }

    public Venice(IInterceptor interceptor) {
        this.interceptor = interceptor == null ? new AcceptAllInterceptor() : interceptor;
        this.meterRegistry = new MeterRegistry(false);
    }

    public IPreCompiled precompile(String scriptName, String script) {
        return this.precompile(scriptName, script, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPreCompiled precompile(String scriptName, String script, boolean macroexpand) {
        if (StringUtil.isBlank(scriptName)) {
            throw new IllegalArgumentException("A 'scriptName' must not be blank");
        }
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        String scriptEff = this.resolveScript(script);
        long startTime = System.currentTimeMillis();
        ThreadContext tc = ThreadContext.get();
        try {
            tc.clear(true);
            tc.setInterceptor_(this.interceptor);
            tc.setMeterRegistry_(this.meterRegistry);
            VeniceInterpreter venice = new VeniceInterpreter(this.interceptor);
            Env env = venice.createEnv(macroexpand, false, RunMode.PRECOMPILE).setStdoutPrintStream(null).setStderrPrintStream(null).setStdinReader(null);
            VncVal ast = venice.READ(scriptEff, scriptName);
            if (macroexpand) {
                ast = venice.MACROEXPAND(ast, env);
            }
            NamespaceRegistry nsRegistry = venice.getNamespaceRegistry().remove(new VncSymbol("core")).copy();
            SymbolTable symbols = env.getGlobalSymbolTableWithoutCoreSystemSymbols();
            PreCompiled preCompiled = new PreCompiled(scriptName, scriptEff, ast, macroexpand, nsRegistry, symbols);
            return preCompiled;
        }
        finally {
            this.lastPrecompileElapsedTimeMillis = System.currentTimeMillis() - startTime;
            tc.clear(false);
        }
    }

    public Object eval(IPreCompiled precompiled) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        return this.eval(precompiled, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(IPreCompiled precompiledScript, Map<String, Object> params) {
        if (precompiledScript == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        PreCompiled precompiled = (PreCompiled)precompiledScript;
        long nanos = System.nanoTime();
        ThreadContext tc = ThreadContext.get();
        try {
            tc.clear(true);
            tc.setInterceptor_(this.interceptor);
            tc.setMeterRegistry_(this.meterRegistry);
            VeniceInterpreter venice = new VeniceInterpreter(this.interceptor, this.meterRegistry, this.serviceRegistry);
            Object object = this.runWithSandbox(venice, () -> {
                NamespaceRegistry nsRegistryPrecompile = precompiled.getNamespaceRegistry();
                SymbolTable coreSystemGlobalSymbols = this.getCoreSystemGlobalSymbols();
                Env env = Env.createPrecompiledEnv(coreSystemGlobalSymbols, precompiled);
                env = this.addParams(env, params);
                precompiled.getSymbols().put(new Var(new VncSymbol("*run-mode*"), RunMode.SCRIPT.mode, false, Var.Scope.Global));
                venice.initNS();
                if (!nsRegistryPrecompile.isEmpty()) {
                    venice.presetNS(nsRegistryPrecompile);
                }
                venice.sealSystemNS();
                venice.setMacroExpandOnLoad(precompiled.isMacroexpand());
                if (this.meterRegistry.enabled) {
                    this.meterRegistry.record("venice.setup", System.nanoTime() - nanos);
                }
                VncVal result = venice.EVAL(precompiled.getPrecompiled(), env);
                Object jResult = result.convertToJavaObject();
                if (this.meterRegistry.enabled) {
                    this.meterRegistry.record("venice.total", System.nanoTime() - nanos);
                }
                return jResult;
            });
            return object;
        }
        finally {
            tc.clear(false);
        }
    }

    public Object eval(String script) {
        return this.eval(null, script, false, null);
    }

    public Object eval(String scriptName, String script) {
        return this.eval(scriptName, script, false, null);
    }

    public Object eval(String script, Map<String, Object> params) {
        return this.eval(null, script, false, params);
    }

    public Object eval(String scriptName, String script, Map<String, Object> params) {
        return this.eval(scriptName, script, false, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String scriptName, String script, boolean macroexpand, Map<String, Object> params) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        String scriptEff = this.resolveScript(script);
        long nanos = System.nanoTime();
        ThreadContext tc = ThreadContext.get();
        try {
            tc.clear(true);
            tc.setInterceptor_(this.interceptor);
            tc.setMeterRegistry_(this.meterRegistry);
            VeniceInterpreter venice = new VeniceInterpreter(this.interceptor, this.meterRegistry, this.serviceRegistry);
            Object object = this.runWithSandbox(venice, () -> {
                Env env = this.createEnv(venice, macroexpand, params);
                this.meterRegistry.reset();
                this.meterRegistry.record("venice.setup", System.nanoTime() - nanos);
                VncVal result = venice.RE(scriptEff, scriptName, env);
                Object jResult = result.convertToJavaObject();
                this.meterRegistry.record("venice.total", System.nanoTime() - nanos);
                return jResult;
            });
            return object;
        }
        finally {
            tc.clear(false);
        }
    }

    public FunctionExecutionMeter getFunctionExecutionMeter() {
        return new FunctionExecutionMeter(this.meterRegistry);
    }

    public long getLastPrecompileElapsedTimeMillis() {
        return this.lastPrecompileElapsedTimeMillis;
    }

    public IServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public static String getVersion() {
        return Version.VERSION;
    }

    public static void shutdownExecutorServices() {
        ConcurrencyFunctions.shutdown();
        ScheduleFunctions.shutdown();
        Agent.shutdown();
    }

    private Env createEnv(IVeniceInterpreter venice, boolean macroexpand, Map<String, Object> params) {
        return this.addParams(venice.createEnv(macroexpand, false, RunMode.SCRIPT), params);
    }

    private Env addParams(Env env, Map<String, Object> params) {
        boolean stdoutAdded = false;
        boolean stderrAdded = false;
        boolean stdinAdded = false;
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                if (key.charAt(0) == '*') {
                    if (key.equals("*out*")) {
                        env.setStdoutPrintStream(this.buildPrintStream(val, "*out*"));
                        stdoutAdded = true;
                        continue;
                    }
                    if (key.equals("*err*")) {
                        env.setStderrPrintStream(this.buildPrintStream(val, "*err*"));
                        stderrAdded = true;
                        continue;
                    }
                    if (key.equals("*in*")) {
                        env.setStdinReader(this.buildIOReader(val, "*in*"));
                        stdinAdded = true;
                        continue;
                    }
                    env.setGlobal(new Var(new VncSymbol(key), JavaInteropUtil.convertToVncVal(val), Var.Scope.Global));
                    continue;
                }
                env.setGlobal(new Var(new VncSymbol(key), JavaInteropUtil.convertToVncVal(val), Var.Scope.Global));
            }
        }
        if (!stdoutAdded) {
            env.setStdoutPrintStream(this.stdout);
        }
        if (!stderrAdded) {
            env.setStderrPrintStream(this.stderr);
        }
        if (!stdinAdded) {
            env.setStdinReader(this.stdin);
        }
        return env;
    }

    private PrintStream buildPrintStream(Object val, String type) {
        if (val == null) {
            return new PrintStream(new NullOutputStream());
        }
        if (val instanceof PrintStream) {
            return (PrintStream)val;
        }
        if (val instanceof OutputStream) {
            return new PrintStream((OutputStream)val, true);
        }
        throw new VncException(String.format("The %s parameter value (%s) must be either null or an instance of PrintStream or OutputStream", type, val.getClass().getSimpleName()));
    }

    private Reader buildIOReader(Object val, String type) {
        if (val == null) {
            return new InputStreamReader(new NullInputStream());
        }
        if (val instanceof InputStream) {
            return new InputStreamReader((InputStream)val);
        }
        if (val instanceof Reader) {
            return (Reader)val;
        }
        throw new VncException(String.format("The %s parameter value (%s) must be either null or an instance of Reader or InputStream", type, val.getClass().getSimpleName()));
    }

    private Object runWithSandbox(IVeniceInterpreter venice, Callable<Object> callable) {
        try {
            if (this.interceptor.getMaxFutureThreadPoolSize() != null) {
                ConcurrencyFunctions.setMaximumFutureThreadPoolSize(this.interceptor.getMaxFutureThreadPoolSize());
            }
            if (this.interceptor.getMaxExecutionTimeSeconds() == null) {
                return callable.call();
            }
            Callable<Object> wrapped = () -> {
                ThreadContext tc = ThreadContext.get();
                try {
                    tc.clear(true);
                    tc.setInterceptor_(this.interceptor);
                    tc.setMeterRegistry_(this.meterRegistry);
                    Object v = callable.call();
                    return v;
                }
                finally {
                    tc.clear(false);
                }
            };
            return this.runWithTimeout(wrapped, this.interceptor.getMaxExecutionTimeSeconds());
        }
        catch (ValueException ex) {
            Object value = ex.getValue();
            throw new ValueException(value instanceof VncVal ? ((VncVal)value).convertToJavaObject() : value);
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof VncException) {
                throw (VncException)cause;
            }
            throw new RuntimeException(ex.getMessage(), cause);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private Object runWithTimeout(Callable<Object> callable, int timeoutSeconds) throws Exception {
        Future<Object> future = mngdExecutor.getExecutor().submit(callable);
        try {
            return future.get(this.interceptor.getMaxExecutionTimeSeconds().intValue(), TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw new SecurityException("Venice Sandbox: The sandbox exceeded the max execution time. Requested cancellation!");
        }
    }

    private SymbolTable getCoreSystemGlobalSymbols() {
        SymbolTable symbols = this.coreSystemGlobalSymbols.get();
        if (symbols == null) {
            Env env = new VeniceInterpreter(this.interceptor, this.meterRegistry, this.serviceRegistry).createEnv(true, false, RunMode.SCRIPT).setStdoutPrintStream(null).setStderrPrintStream(null).setStdinReader(null);
            symbols = env.getGlobalSymbolTable();
            this.coreSystemGlobalSymbols.set(symbols);
        }
        return symbols;
    }

    private String resolveScript(String script) {
        if (script.startsWith("classpath:")) {
            return new ClassPathResource(script.substring("classpath:".length())).getResourceAsString("UTF-8");
        }
        return script;
    }
}

