/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.ExcelColumnDef;
import com.github.jlangch.venice.util.excel.DataRecord;
import com.github.jlangch.venice.util.excel.ExcelSheetBuilder;
import java.util.List;
import java.util.function.Function;

public class ExcelColumnBuilder<T> {
    private final ExcelSheetBuilder<T> parentBuilder;
    private final List<ExcelColumnDef<T>> columnDefs;
    private Function<? super T, ?> mapper;
    private String name;
    private Integer width;
    private String headerStyle;
    private String bodyStyle;
    private String footerStyle;
    private Object footerValue;
    private boolean hidden = false;
    private ExcelColumnDef.FooterType footerType = ExcelColumnDef.FooterType.NONE;

    public ExcelColumnBuilder(ExcelSheetBuilder<T> excelSheetBuilder, List<ExcelColumnDef<T>> columnDefs, String name) {
        this.parentBuilder = excelSheetBuilder;
        this.columnDefs = columnDefs;
        this.name = name;
    }

    public ExcelColumnBuilder<T> colMapper(Function<? super T, ?> mapper) {
        this.mapper = mapper;
        return this;
    }

    public ExcelColumnBuilder<T> colMapper(String fieldName) {
        this.mapper = e -> ((DataRecord)e).get(fieldName);
        return this;
    }

    public ExcelColumnBuilder<T> widthInPoints(int width) {
        this.width = width;
        return this;
    }

    public ExcelColumnBuilder<T> hidden(boolean hide) {
        this.hidden = hide;
        return this;
    }

    public ExcelColumnBuilder<T> headerStyle(String style) {
        this.headerStyle = style;
        return this;
    }

    public ExcelColumnBuilder<T> bodyStyle(String style) {
        this.bodyStyle = style;
        return this;
    }

    public ExcelColumnBuilder<T> footerStyle(String style) {
        this.footerStyle = style;
        return this;
    }

    public ExcelColumnBuilder<T> footerTextValue(String text) {
        this.footerValue = text;
        this.footerType = ExcelColumnDef.FooterType.TEXT;
        return this;
    }

    public ExcelColumnBuilder<T> footerNumberValue(Number number) {
        this.footerValue = number;
        this.footerType = ExcelColumnDef.FooterType.NUMBER;
        return this;
    }

    public ExcelColumnBuilder<T> footerMin() {
        this.footerValue = null;
        this.footerType = ExcelColumnDef.FooterType.MIN;
        return this;
    }

    public ExcelColumnBuilder<T> footerMax() {
        this.footerValue = null;
        this.footerType = ExcelColumnDef.FooterType.MAX;
        return this;
    }

    public ExcelColumnBuilder<T> footerAverage() {
        this.footerValue = null;
        this.footerType = ExcelColumnDef.FooterType.AVERAGE;
        return this;
    }

    public ExcelColumnBuilder<T> footerSum() {
        this.footerValue = null;
        this.footerType = ExcelColumnDef.FooterType.SUM;
        return this;
    }

    public ExcelSheetBuilder<T> end() {
        if (!this.hidden) {
            this.columnDefs.add(new ExcelColumnDef<T>(this.name, this.mapper, this.width, this.headerStyle, this.bodyStyle, this.footerStyle, this.footerValue, this.footerType));
        }
        return this.parentBuilder;
    }
}

