/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io;

import com.github.jlangch.venice.util.NullInputStream;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

public class IOStreamUtil {
    public static byte[] copyIStoByteArray(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[16384];
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static byte[] copyIStoByteArray(InputStream input, int numBytesToCopy) throws IOException {
        int offset;
        int read;
        if (numBytesToCopy < 0) {
            throw new IllegalArgumentException("numBytesToCopy must not be negative: " + numBytesToCopy);
        }
        if (numBytesToCopy == 0) {
            return new byte[0];
        }
        byte[] data = new byte[numBytesToCopy];
        for (offset = 0; offset < numBytesToCopy && (read = input.read(data, offset, numBytesToCopy - offset)) != -1; offset += read) {
        }
        if (offset != numBytesToCopy) {
            throw new IOException("Unexpected read size. current: " + offset + ", expected: " + numBytesToCopy);
        }
        return data;
    }

    public static String copyIStoString(InputStream is, String encoding) throws IOException {
        return is == null ? null : new String(IOStreamUtil.copyIStoByteArray(is), encoding == null ? Charset.defaultCharset().name() : encoding);
    }

    public static void copyByteArrayToOS(byte[] data, OutputStream os) throws IOException {
        if (os == null || data == null) {
            return;
        }
        os.write(data);
        os.flush();
    }

    public static void copyFileToOS(File file, OutputStream os) throws IOException {
        if (os == null || file == null) {
            return;
        }
        try (FileInputStream is = new FileInputStream(file);){
            IOStreamUtil.copy(is, os);
        }
    }

    public static void copyStringToOS(String data, OutputStream os, String encoding) throws IOException {
        if (os == null || data == null) {
            return;
        }
        os.write(encoding == null ? data.getBytes(Charset.defaultCharset()) : data.getBytes(encoding));
        os.flush();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
        os.flush();
    }

    public static PrintStream nullPrintStream() {
        return new PrintStream(new NullOutputStream(), true);
    }

    public static BufferedReader nullBufferedReader() {
        return new BufferedReader(new InputStreamReader(new NullInputStream()));
    }
}

