/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMutable;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.StreamUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.repackage.io.vavr.collection.HashSet;

public class VncJavaSet
extends VncSet
implements IVncJavaObject,
VncMutable {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Set<Object> value;

    public VncJavaSet() {
        this((Set<Object>)null, (VncVal)null);
    }

    public VncJavaSet(VncVal meta) {
        this((Set<Object>)null, meta);
    }

    public VncJavaSet(Set<Object> val) {
        this(val, null);
    }

    private VncJavaSet(Set<Object> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? new java.util.HashSet() : val;
    }

    public static VncJavaSet of(Object ... vals) {
        java.util.HashSet<Object> set = new java.util.HashSet<Object>();
        for (Object o : vals) {
            set.add(o);
        }
        return new VncJavaSet(set, (VncVal)Constants.Nil);
    }

    public static VncJavaSet ofAll(Iterable<Object> iter) {
        java.util.HashSet<Object> set = new java.util.HashSet<Object>();
        for (Object o : iter) {
            set.add(o);
        }
        return new VncJavaSet(set, null);
    }

    public static VncJavaSet ofAll(Iterable<Object> iter, VncVal meta) {
        java.util.HashSet<Object> set = new java.util.HashSet<Object>();
        for (Object o : iter) {
            set.add(o);
        }
        return new VncJavaSet(set, meta);
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncJavaSet emptyWithMeta() {
        return new VncJavaSet(this.getMeta());
    }

    @Override
    public VncHashSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncHashSet(HashSet.ofAll(replaceVals), this.getMeta());
    }

    @Override
    public VncHashSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncHashSet(HashSet.ofAll(replaceVals), meta);
    }

    @Override
    public VncJavaSet withMeta(VncVal meta) {
        return new VncJavaSet(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        Class<?> type = this.value.getClass();
        ArrayList<VncKeyword> superclasses = new ArrayList<VncKeyword>();
        for (Class<?> superClass = type.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            superclasses.add(new VncKeyword(superClass.getName(), MetaUtil.typeMeta(new VncKeyword[0])));
        }
        return new VncKeyword(type.getName(), MetaUtil.typeMeta(superclasses.toArray(new VncKeyword[0])));
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public VncJavaSet add(VncVal val) {
        this.value.add(val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaSet addAll(VncSet val) {
        if (Types.isVncJavaSet(val)) {
            this.value.addAll(((VncJavaSet)val).value);
        } else {
            val.forEach(v -> this.add((VncVal)v));
        }
        return this;
    }

    @Override
    public VncJavaSet addAll(VncSequence val) {
        if (Types.isVncJavaList(val)) {
            this.value.addAll((List)((VncJavaList)val).getDelegate());
        } else {
            val.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)v -> this.add((VncVal)v)));
        }
        return this;
    }

    @Override
    public VncJavaSet remove(VncVal val) {
        this.value.remove(val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaSet removeAll(VncSet val) {
        if (Types.isVncJavaSet(val)) {
            this.value.removeAll(((VncJavaSet)val).value);
        } else {
            val.forEach(v -> this.remove((VncVal)v));
        }
        return this;
    }

    @Override
    public VncJavaSet removeAll(VncSequence val) {
        if (Types.isVncJavaList(val)) {
            this.value.removeAll((List)((VncJavaList)val).getDelegate());
        } else {
            val.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)v -> this.remove((VncVal)v)));
        }
        return this;
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val.convertToJavaObject());
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : new MappingIterator(this.value.iterator());
    }

    @Override
    public Stream<VncVal> stream() {
        return StreamUtil.stream(this.iterator());
    }

    @Override
    public Set<VncVal> getJavaSet() {
        return Collections.unmodifiableSet(this.getVncValueSet());
    }

    @Override
    public List<VncVal> getJavaList() {
        return Collections.unmodifiableList(this.getVncValueList());
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.JAVASET;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJavaSet(o)) {
            int c = Integer.compare(this.size(), ((VncJavaSet)o).size());
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaSet other = (VncJavaSet)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "#{" + Printer.join(this.stream(), " ", print_machine_readably) + "}";
    }

    private List<VncVal> getVncValueList() {
        return this.stream().collect(Collectors.toList());
    }

    private Set<VncVal> getVncValueSet() {
        return this.stream().collect(Collectors.toSet());
    }

    private static class MappingIterator
    implements Iterator<VncVal> {
        private final Iterator<Object> iter;

        public MappingIterator(Iterator<Object> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public VncVal next() {
            return JavaInteropUtil.convertToVncVal(this.iter.next());
        }

        public String toString() {
            return "MappingIterator()";
        }
    }
}

