/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMutable;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class VncDelayQueue
extends VncCollection
implements VncMutable {
    public static final String TYPE = ":core/delay-queue";
    private static final long serialVersionUID = -564531670922145260L;
    private final DelayQueue<DelayedVal> queue;

    public VncDelayQueue(VncVal meta) {
        super(meta);
        this.queue = new DelayQueue();
    }

    private VncDelayQueue(VncDelayQueue queue, VncVal meta) {
        super(meta);
        this.queue = queue.queue;
    }

    @Override
    public VncCollection emptyWithMeta() {
        return new VncDelayQueue(this.getMeta());
    }

    @Override
    public VncDelayQueue withMeta(VncVal meta) {
        return new VncDelayQueue(this, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public VncList toVncList() {
        return VncList.empty();
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.empty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void put(VncVal val, long delay, TimeUnit unit) {
        this.queue.put(new DelayedVal(val, delay, unit));
    }

    public VncVal poll() {
        DelayedVal val = (DelayedVal)this.queue.poll();
        return val == null ? Constants.Nil : val.deref();
    }

    public VncVal poll(long timeoutMillis) {
        try {
            DelayedVal val = (DelayedVal)this.queue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            return val == null ? Constants.Nil : val.deref();
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (poll! delay-queue)", ex);
        }
    }

    public VncVal peek() {
        DelayedVal val = (DelayedVal)this.queue.peek();
        return val == null ? Constants.Nil : val.deref();
    }

    public VncVal take() {
        try {
            DelayedVal val = (DelayedVal)this.queue.take();
            return val == null ? Constants.Nil : val.deref();
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (take! delay-queue)", ex);
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.QUEUE;
    }

    @Override
    public Object convertToJavaObject() {
        return Arrays.stream(this.queue.toArray(new VncVal[0])).map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    public String toString() {
        return TYPE;
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return TYPE;
    }

    private static int saturatedCastToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    private static class DelayedVal
    implements IDeref,
    Delayed {
        private final VncVal val;
        private final long delayTo;
        private final long delayMillis;

        public DelayedVal(VncVal val, long delay, TimeUnit unit) {
            this.val = val;
            this.delayMillis = unit.toMillis(delay);
            this.delayTo = System.currentTimeMillis() + this.delayMillis;
        }

        @Override
        public VncVal deref() {
            return this.val;
        }

        @Override
        public int compareTo(Delayed o) {
            return VncDelayQueue.saturatedCastToInt(this.delayTo - ((DelayedVal)o).delayTo);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delayTo - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

