/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class VncLong
extends VncNumber {
    public static final String TYPE = ":core/long";
    private static final long serialVersionUID = -1848883965231344442L;
    private final long value;

    public VncLong(long v) {
        super(null, Constants.Nil);
        this.value = v;
    }

    public VncLong(long v, VncVal meta) {
        super(null, meta);
        this.value = v;
    }

    public VncLong(Long v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncLong of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncLong(((VncNumber)v).toJavaLong());
        }
        throw new VncException(String.format("Cannot convert value of type %s to long", Types.getType(v)));
    }

    @Override
    public VncLong withMeta(VncVal meta) {
        return new VncLong(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncLong wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncLong(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/number"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/number"), new VncKeyword(":core/val")));
    }

    @Override
    public VncLong inc() {
        return new VncLong(this.value + 1L);
    }

    @Override
    public VncLong dec() {
        return new VncLong(this.value - 1L);
    }

    @Override
    public VncLong negate() {
        return new VncLong(Math.negateExact(this.value));
    }

    @Override
    public VncNumber add(VncVal op) {
        if (op instanceof VncLong) {
            return new VncLong(this.value + ((VncLong)op).value);
        }
        if (op instanceof VncInteger) {
            return new VncLong(this.value + ((VncInteger)op).toJavaLong());
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value + ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.toJavaBigInteger().add(((VncBigInteger)op).toJavaBigInteger()));
        }
        throw new VncException(String.format("Function + operand 2 (%s) is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber sub(VncVal op) {
        if (op instanceof VncLong) {
            return new VncLong(this.value - ((VncLong)op).value);
        }
        if (op instanceof VncInteger) {
            return new VncLong(this.value - ((VncInteger)op).toJavaLong());
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value - ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.toJavaBigInteger().subtract(((VncBigInteger)op).toJavaBigInteger()));
        }
        throw new VncException(String.format("Function - operand 2 (%s) is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber mul(VncVal op) {
        if (op instanceof VncLong) {
            return new VncLong(this.value * ((VncLong)op).value);
        }
        if (op instanceof VncInteger) {
            return new VncLong(this.value * ((VncInteger)op).toJavaLong());
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value * ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.toJavaBigInteger().multiply(((VncBigInteger)op).toJavaBigInteger()));
        }
        throw new VncException(String.format("Function * operand 2 (%s) is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber div(VncVal op) {
        try {
            if (op instanceof VncLong) {
                return new VncLong(this.value / ((VncLong)op).value);
            }
            if (op instanceof VncInteger) {
                return new VncLong(this.value / ((VncInteger)op).toJavaLong());
            }
            if (op instanceof VncDouble) {
                return new VncDouble((double)this.value / ((VncDouble)op).toJavaDouble());
            }
            if (op instanceof VncBigDecimal) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigDecimal)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            if (op instanceof VncBigInteger) {
                return new VncBigInteger(this.toJavaBigInteger().divide(((VncBigInteger)op).toJavaBigInteger()));
            }
            throw new VncException(String.format("Function / operand 2 (%s) is not a numeric type", Types.getType(op)));
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
    }

    @Override
    public VncBoolean equ(VncVal other) {
        if (other instanceof VncLong) {
            return VncBoolean.of(this.value == ((VncLong)other).value);
        }
        if (other instanceof VncInteger) {
            return VncBoolean.of(this.value == ((VncInteger)other).toJavaLong());
        }
        if (other instanceof VncDouble) {
            return VncBoolean.of((double)this.value == ((VncDouble)other).toJavaDouble());
        }
        if (other instanceof VncBigDecimal) {
            return VncBoolean.of(this.toJavaBigDecimal().compareTo(((VncBigDecimal)other).toJavaBigDecimal()) == 0);
        }
        if (other instanceof VncBigInteger) {
            return VncBoolean.of(this.toJavaBigInteger().compareTo(((VncBigInteger)other).toJavaBigInteger()) == 0);
        }
        throw new VncException(String.format("Function == operand 2 (%s) is not a numeric type", Types.getType(other)));
    }

    @Override
    public VncBoolean zeroQ() {
        return VncBoolean.of(this.value == 0L);
    }

    @Override
    public VncBoolean posQ() {
        return VncBoolean.of(this.value > 0L);
    }

    @Override
    public VncBoolean negQ() {
        return VncBoolean.of(this.value < 0L);
    }

    @Override
    public VncNumber square() {
        return new VncLong(this.value * this.value);
    }

    @Override
    public VncNumber sqrt() {
        return new VncDouble(Math.sqrt(this.value));
    }

    public Long getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        return (int)this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.LONG;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int toJavaInteger() {
        return (int)this.value;
    }

    @Override
    public long toJavaLong() {
        return this.value;
    }

    @Override
    public double toJavaDouble() {
        return this.value;
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return new BigDecimal(this.value).setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncLong(o)) {
            long other = ((VncLong)o).value;
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncInteger(o)) {
            long other = ((VncInteger)o).toJavaLong();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncDouble(o)) {
            long other = ((VncDouble)o).toJavaLong();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncBigDecimal(o)) {
            long other = ((VncBigDecimal)o).toJavaLong();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncBigInteger(o)) {
            long other = ((VncBigInteger)o).toJavaLong();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((VncLong)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

