/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.sandbox;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RestrictedBlacklistedFunctions {
    private static Set<String> IO = new HashSet<String>(Arrays.asList("print", "printf", "println", "newline", "load-file", "load-classpath-file", "load-resource", "load-file*", "load-resource*", "load-classpath-file*", "load-jar", "classloader", "classloader-of", "gc", "shutdown-hook", "sh", "callstack", "deliver", "future", "future?", "future-cancel", "future-cancelled?", "future-done?", "futures-fork", "futures-wait", "promise", "promise?", "agent", "send", "send-off", "restart-agent", "set-error-handler!", "agent-error", "agent-error-mode", "await", "await-for", "shutdown-agents", "shutdown-agents?", "await-termination-agents", "await-termination-agents?", "thread", "schedule-delay", "schedule-at-fixed-rate", "thread-local", "thread-local?", "thread-local-map", "thread-local-clear", "fn-body", "fn-pre-conditions", "io/copy-file", "io/copy-stream", "io/delete-file", "io/delete-file-on-exit", "io/delete-file-tree", "io/delete-files-glob", "io/download", "io/exists-dir?", "io/exists-file?", "io/file-size", "io/file-in-stream", "io/list-file-tree", "io/list-files", "io/list-files-glob", "io/load-classpath-resource", "io/move-file", "io/mkdir", "io/mkdirs", "io/slurp", "io/slurp-lines", "io/slurp-stream", "io/spit", "io/spit-stream", "io/temp-dir", "io/temp-file", "io/tmp-dir", "io/touch-file", "io/uri-stream", "io/user-dir", "io/wait-for", "io/zip", "io/zip-append", "io/zip-remove", "io/zip-file", "io/zip-list", "io/unzip", "io/unzip-first", "io/unzip-nth", "io/unzip-all", "io/unzip-to-dir", "io/zip-size", "io/gzip", "io/gzip-to-stream", "io/ungzip", "io/ungzip-to-stream"));
    private static Set<String> SPECIAL_FORMS = new HashSet<String>(Arrays.asList("set!", "ns-remove", "ns-unmap", "resolve", "var-get", "var-ns", "var-name", "inspect", "dorun", "dobench", "prof"));
    private static Set<String> ALL = RestrictedBlacklistedFunctions.merge(IO, SPECIAL_FORMS);

    public static Set<String> getIoFunctions() {
        return IO;
    }

    public static Set<String> getSpecialForms() {
        return SPECIAL_FORMS;
    }

    public static Set<String> getAll() {
        return ALL;
    }

    public static boolean contains(String funcName) {
        return ALL.contains(funcName);
    }

    private static Set<String> merge(Set<String> s1, Set<String> s2) {
        HashSet<String> set = new HashSet<String>(s1);
        set.addAll(s2);
        return set;
    }
}

