/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.aprilapps.easyphotopicker.Files;
import pl.aprilapps.easyphotopicker.MediaFile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0003J+\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u001d\u0010#\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b%J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\bH\u0002\u00a8\u0006/"}, d2={"Lpl/aprilapps/easyphotopicker/Files;", "", "()V", "copyImageToPublicGallery", "", "context", "Landroid/content/Context;", "fileToCopy", "Ljava/io/File;", "folderName", "copyImagesToPublicGallery", "", "filesToCopy", "", "copyImagesToPublicGallery$com_github_jkwiecien_EasyImageLegacy", "createCameraPictureFile", "Lpl/aprilapps/easyphotopicker/MediaFile;", "createCameraPictureFile$com_github_jkwiecien_EasyImageLegacy", "createCameraVideoFile", "createCameraVideoFile$com_github_jkwiecien_EasyImageLegacy", "flipImage", "Landroid/graphics/Bitmap;", "bitmap", "horizontal", "", "vertical", "generateFileName", "getFixedRotationBitmap", "bitmapFile", "getMimeType", "uri", "Landroid/net/Uri;", "getUriToFile", "file", "legacyCopyImageToPublicGallery", "pickedExistingPicture", "photoUri", "pickedExistingPicture$com_github_jkwiecien_EasyImageLegacy", "rotateImage", "degrees", "", "runMediaScanner", "paths", "tempImageDirectory", "writeToFile", "inputStream", "Ljava/io/InputStream;", "com.github.jkwiecien.EasyImageLegacy"})
public final class Files {
    @NotNull
    public static final Files INSTANCE;

    private final File tempImageDirectory(Context context) {
        File privateTempDir = new File(context.getCacheDir(), "EasyImage");
        if (!privateTempDir.exists()) {
            privateTempDir.mkdirs();
        }
        return privateTempDir;
    }

    private final String generateFileName() {
        return "ei_" + System.currentTimeMillis();
    }

    private final void writeToFile(InputStream inputStream, File file) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int length = inputStream.read(buffer);
            while (length > 0) {
                outputStream.write(buffer, 0, length);
                length = inputStream.read(buffer);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final Bitmap rotateImage(Bitmap bitmap, float degrees) {
        Matrix matrix = new Matrix();
        matrix.postRotate(degrees);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026map.height, matrix, true)");
        return bitmap2;
    }

    private final Bitmap flipImage(Bitmap bitmap, boolean horizontal, boolean vertical) {
        Matrix matrix = new Matrix();
        matrix.preScale((float)(horizontal ? -1 : 1), (float)(vertical ? -1 : 1));
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026map.height, matrix, true)");
        return bitmap2;
    }

    private final Bitmap getFixedRotationBitmap(File bitmapFile) {
        Bitmap bitmap;
        ExifInterface exifInterface = new ExifInterface(bitmapFile.getPath());
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        Bitmap bitmap2 = BitmapFactory.decodeFile((String)bitmapFile.getPath());
        boolean bl = false;
        boolean bl2 = false;
        Bitmap $this$with = bitmap2;
        boolean bl3 = false;
        switch (orientation) {
            case 6: {
                Bitmap bitmap3 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"this");
                bitmap = INSTANCE.rotateImage(bitmap3, 90.0f);
                break;
            }
            case 3: {
                Bitmap bitmap4 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"this");
                bitmap = INSTANCE.rotateImage(bitmap4, 180.0f);
                break;
            }
            case 8: {
                Bitmap bitmap5 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"this");
                bitmap = INSTANCE.rotateImage(bitmap5, 270.0f);
                break;
            }
            case 2: {
                Bitmap bitmap6 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap6, (String)"this");
                bitmap = INSTANCE.flipImage(bitmap6, true, false);
                break;
            }
            case 4: {
                Bitmap bitmap7 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap7, (String)"this");
                bitmap = INSTANCE.flipImage(bitmap7, false, true);
                break;
            }
            default: {
                bitmap = $this$with;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"with(BitmapFactory.decod\u2026s\n            }\n        }");
        return bitmap;
    }

    @RequiresApi(value=29)
    private final String copyImageToPublicGallery(Context context, File fileToCopy, String folderName) {
        Bitmap bitmapToCopy = this.getFixedRotationBitmap(fileToCopy);
        ContentResolver contentResolver = context.getContentResolver();
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileToCopy.getName());
        contentValues.put("mime_type", "image/jpg");
        contentValues.put("relative_path", Environment.DIRECTORY_PICTURES + '/' + folderName);
        Uri uri = contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        Intrinsics.checkNotNull((Object)uri);
        Uri copyUri = uri;
        OutputStream outputStream = contentResolver.openOutputStream(copyUri);
        Intrinsics.checkNotNull((Object)outputStream);
        OutputStream outputStream2 = outputStream;
        bitmapToCopy.compress(Bitmap.CompressFormat.JPEG, 100, outputStream2);
        outputStream2.close();
        Log.d((String)"EasyImage", (String)("Copied image to public gallery: " + copyUri.getPath()));
        String string = copyUri.getPath();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String legacyCopyImageToPublicGallery(File fileToCopy, String folderName) {
        Bitmap bitmapToCopy = this.getFixedRotationBitmap(fileToCopy);
        File legacyExternalStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), folderName);
        if (!legacyExternalStorageDir.exists()) {
            legacyExternalStorageDir.mkdirs();
        }
        File copyFile = new File(legacyExternalStorageDir, fileToCopy.getName());
        copyFile.createNewFile();
        FileOutputStream outputStream = new FileOutputStream(copyFile);
        bitmapToCopy.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        outputStream.close();
        Log.d((String)"EasyImage", (String)("Copied image to public gallery: " + copyFile.getPath()));
        String string = copyFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"copyFile.path");
        return string;
    }

    public final void copyImagesToPublicGallery$com_github_jkwiecien_EasyImageLegacy(@NotNull Context context, @NotNull String folderName, @NotNull List<? extends File> filesToCopy) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        Intrinsics.checkNotNullParameter(filesToCopy, (String)"filesToCopy");
        new Thread(new Runnable(filesToCopy, context, folderName){
            final /* synthetic */ List $filesToCopy;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $folderName;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$filesToCopy;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    void fileToCopy;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    try {
                        string = Build.VERSION.SDK_INT >= 29 ? Files.access$copyImageToPublicGallery(Files.INSTANCE, this.$context, (File)fileToCopy, this.$folderName) : Files.access$legacyCopyImageToPublicGallery(Files.INSTANCE, (File)fileToCopy, this.$folderName);
                    }
                    catch (Throwable error) {
                        error.printStackTrace();
                        Log.e((String)"EasyImage", (String)("File couldn't be copied to public gallery: " + fileToCopy.getName()));
                        string = null;
                    }
                    String string2 = string;
                    collection.add(string2);
                }
                List copiedFilesPaths = (List)destination$iv$iv;
                Files.access$runMediaScanner(Files.INSTANCE, this.$context, CollectionsKt.filterNotNull((Iterable)copiedFilesPaths));
            }
            {
                this.$filesToCopy = list;
                this.$context = context;
                this.$folderName = string;
            }
        }).run();
    }

    private final void runMediaScanner(Context context, List<String> paths) {
        Collection $this$toTypedArray$iv = paths;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        MediaScannerConnection.scanFile((Context)context, (String[])stringArray, null, (MediaScannerConnection.OnScanCompletedListener)runMediaScanner.1.INSTANCE);
    }

    @NotNull
    public final File pickedExistingPicture$com_github_jkwiecien_EasyImageLegacy(@NotNull Context context, @NotNull Uri photoUri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)photoUri, (String)"photoUri");
        InputStream inputStream = context.getContentResolver().openInputStream(photoUri);
        if (inputStream == null) {
            throw (Throwable)new IOException("Could not open input stream for a file: " + photoUri);
        }
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.contentResolver.\u2026m for a file: $photoUri\")");
        InputStream pictureInputStream = inputStream;
        File directory = this.tempImageDirectory(context);
        File photoFile = new File(directory, this.generateFileName() + "." + this.getMimeType(context, photoUri));
        photoFile.createNewFile();
        this.writeToFile(pictureInputStream, photoFile);
        return photoFile;
    }

    private final String getMimeType(Context context, Uri uri) {
        String extension = null;
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        }
        return extension;
    }

    private final Uri getUriToFile(Context context, File file) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        String packageName = context2.getPackageName();
        String authority = packageName + ".easyphotopicker.fileprovider";
        Uri uri = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"FileProvider.getUriForFi\u2026context, authority, file)");
        return uri;
    }

    @NotNull
    public final MediaFile createCameraPictureFile$com_github_jkwiecien_EasyImageLegacy(@NotNull Context context) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File dir = this.tempImageDirectory(context);
        File file2 = file = File.createTempFile(this.generateFileName(), ".jpg", dir);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        Uri uri = this.getUriToFile(context, file2);
        return new MediaFile(uri, file);
    }

    @NotNull
    public final MediaFile createCameraVideoFile$com_github_jkwiecien_EasyImageLegacy(@NotNull Context context) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File dir = this.tempImageDirectory(context);
        File file2 = file = File.createTempFile(this.generateFileName(), ".mp4", dir);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        Uri uri = this.getUriToFile(context, file2);
        return new MediaFile(uri, file);
    }

    private Files() {
    }

    static {
        Files files;
        INSTANCE = files = new Files();
    }

    public static final /* synthetic */ String access$copyImageToPublicGallery(Files $this, Context context, File fileToCopy, String folderName) {
        return $this.copyImageToPublicGallery(context, fileToCopy, folderName);
    }

    public static final /* synthetic */ String access$legacyCopyImageToPublicGallery(Files $this, File fileToCopy, String folderName) {
        return $this.legacyCopyImageToPublicGallery(fileToCopy, folderName);
    }

    public static final /* synthetic */ void access$runMediaScanner(Files $this, Context context, List paths) {
        $this.runMediaScanner(context, paths);
    }
}

