/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import pl.aprilapps.easyphotopicker.MediaFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J+\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\fH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u001d\u0010\u001b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001dJ\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002\u00a8\u0006$"}, d2={"Lpl/aprilapps/easyphotopicker/Files;", "", "()V", "copyFile", "", "src", "Ljava/io/File;", "dst", "copyFilesInSeparateThread", "context", "Landroid/content/Context;", "folderName", "", "filesToCopy", "", "copyFilesInSeparateThread$library_release", "createCameraPictureFile", "Lpl/aprilapps/easyphotopicker/MediaFile;", "createCameraPictureFile$library_release", "createCameraVideoFile", "createCameraVideoFile$library_release", "generateFileName", "getMimeType", "uri", "Landroid/net/Uri;", "getUriToFile", "file", "pickedExistingPicture", "photoUri", "pickedExistingPicture$library_release", "scanCopiedImages", "copiedImages", "tempImageDirectory", "writeToFile", "inputStream", "Ljava/io/InputStream;", "library_release"})
public final class Files {
    public static final Files INSTANCE;

    private final File tempImageDirectory(Context context) {
        File privateTempDir = new File(context.getCacheDir(), "EasyImage");
        if (!privateTempDir.exists()) {
            privateTempDir.mkdirs();
        }
        return privateTempDir;
    }

    private final String generateFileName() {
        return "ei_" + System.currentTimeMillis();
    }

    private final void writeToFile(InputStream inputStream, File file) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int length = inputStream.read(buffer);
            while (length > 0) {
                outputStream.write(buffer, 0, length);
                length = inputStream.read(buffer);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void copyFile(File src, File dst) throws IOException {
        FileInputStream inputStream = new FileInputStream(src);
        this.writeToFile(inputStream, dst);
    }

    public final void copyFilesInSeparateThread$library_release(@NotNull Context context, @NotNull String folderName, @NotNull List<? extends File> filesToCopy) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)folderName, (String)"folderName");
        Intrinsics.checkParameterIsNotNull(filesToCopy, (String)"filesToCopy");
        new Thread(new Runnable(filesToCopy, folderName, context){
            final /* synthetic */ List $filesToCopy;
            final /* synthetic */ String $folderName;
            final /* synthetic */ Context $context;

            public final void run() {
                ArrayList<File> copiedFiles = new ArrayList<File>();
                int i = 1;
                for (File fileToCopy : this.$filesToCopy) {
                    String[] filenameSplit;
                    List list;
                    File dstDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), this.$folderName);
                    if (!dstDir.exists()) {
                        dstDir.mkdirs();
                    }
                    String string = fileToCopy.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileToCopy.name");
                    CharSequence charSequence = string;
                    String string2 = "\\.";
                    int n = 0;
                    string2 = new Regex(string2);
                    n = 0;
                    boolean bl = false;
                    List $this$dropLastWhile$iv = string2.split(charSequence, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            CharSequence charSequence2 = it;
                            boolean bl3 = false;
                            if (charSequence2.length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    Collection $this$toTypedArray$iv = list;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new String[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String extension = "." + filenameSplit[filenameSplit.length - 1];
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
                    Calendar calendar = Calendar.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
                    String datePart = simpleDateFormat.format(calendar.getTime());
                    String filename = "IMG_" + datePart + '_' + i + '.' + extension + "%d.%s";
                    File dstFile = new File(dstDir, filename);
                    try {
                        dstFile.createNewFile();
                        Files.access$copyFile(Files.INSTANCE, fileToCopy, dstFile);
                        copiedFiles.add(dstFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                Files.access$scanCopiedImages(Files.INSTANCE, this.$context, copiedFiles);
            }
            {
                this.$filesToCopy = list;
                this.$folderName = string;
                this.$context = context;
            }
        }).run();
    }

    /*
     * WARNING - void declaration
     */
    private final void scanCopiedImages(Context context, List<? extends File> copiedImages) {
        String[] paths = new String[copiedImages.size()];
        int n = 0;
        int n2 = ((Collection)copiedImages).size();
        while (n < n2) {
            void i;
            paths[i] = copiedImages.get((int)i).toString();
            ++i;
        }
        MediaScannerConnection.scanFile((Context)context, (String[])paths, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(@NotNull String path, @NotNull Uri uri) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                Log.d((String)this.getClass().getSimpleName(), (String)("Scanned " + path + ':'));
                Log.d((String)this.getClass().getSimpleName(), (String)("-> uri=" + uri));
            }
        });
    }

    @NotNull
    public final File pickedExistingPicture$library_release(@NotNull Context context, @NotNull Uri photoUri) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)photoUri, (String)"photoUri");
        InputStream pictureInputStream = context.getContentResolver().openInputStream(photoUri);
        File directory = this.tempImageDirectory(context);
        File photoFile = new File(directory, this.generateFileName() + "." + this.getMimeType(context, photoUri));
        photoFile.createNewFile();
        InputStream inputStream = pictureInputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"pictureInputStream");
        this.writeToFile(inputStream, photoFile);
        return photoFile;
    }

    private final String getMimeType(Context context, Uri uri) {
        String extension = null;
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        }
        return extension;
    }

    private final Uri getUriToFile(Context context, File file) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        String packageName = context2.getPackageName();
        String authority = packageName + ".easyphotopicker.fileprovider";
        Uri uri = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"FileProvider.getUriForFi\u2026context, authority, file)");
        return uri;
    }

    @NotNull
    public final MediaFile createCameraPictureFile$library_release(@NotNull Context context) throws IOException {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File dir = this.tempImageDirectory(context);
        File file2 = file = File.createTempFile(this.generateFileName(), ".jpg", dir);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        Uri uri = this.getUriToFile(context, file2);
        return new MediaFile(uri, file);
    }

    @NotNull
    public final MediaFile createCameraVideoFile$library_release(@NotNull Context context) throws IOException {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File dir = this.tempImageDirectory(context);
        File file2 = file = File.createTempFile(this.generateFileName(), ".mp4", dir);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        Uri uri = this.getUriToFile(context, file2);
        return new MediaFile(uri, file);
    }

    private Files() {
    }

    static {
        Files files;
        INSTANCE = files = new Files();
    }

    public static final /* synthetic */ void access$copyFile(Files $this, File src, File dst) {
        $this.copyFile(src, dst);
    }

    public static final /* synthetic */ void access$scanCopiedImages(Files $this, Context context, List copiedImages) {
        $this.scanCopiedImages(context, copiedImages);
    }
}

