/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import pl.aprilapps.easyphotopicker.Constants;
import pl.aprilapps.easyphotopicker.EasyImage;

class EasyImageFiles
implements Constants {
    EasyImageFiles() {
    }

    private static String getFolderName(@NonNull Context context) {
        return EasyImage.configuration(context).getFolderName();
    }

    private static File tempImageDirectory(@NonNull Context context) {
        File privateTempDir = new File(context.getCacheDir(), "EasyImage");
        if (!privateTempDir.exists()) {
            privateTempDir.mkdirs();
        }
        return privateTempDir;
    }

    private static void writeToFile(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = new FileInputStream(src);
        EasyImageFiles.writeToFile(in, dst);
    }

    static void copyFilesInSeparateThread(final Context context, final List<File> filesToCopy) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<File> copiedFiles = new ArrayList<File>();
                int i = 1;
                for (File fileToCopy : filesToCopy) {
                    File dstDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), EasyImageFiles.getFolderName(context));
                    if (!dstDir.exists()) {
                        dstDir.mkdirs();
                    }
                    String[] filenameSplit = fileToCopy.getName().split("\\.");
                    String extension = "." + filenameSplit[filenameSplit.length - 1];
                    String filename = String.format("IMG_%s_%d.%s", new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime()), i, extension);
                    File dstFile = new File(dstDir, filename);
                    try {
                        dstFile.createNewFile();
                        EasyImageFiles.copyFile(fileToCopy, dstFile);
                        copiedFiles.add(dstFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                EasyImageFiles.scanCopiedImages(context, copiedFiles);
            }
        }).run();
    }

    static List<File> singleFileList(File file) {
        ArrayList<File> list = new ArrayList<File>();
        list.add(file);
        return list;
    }

    static void scanCopiedImages(Context context, List<File> copiedImages) {
        String[] paths = new String[copiedImages.size()];
        for (int i = 0; i < copiedImages.size(); ++i) {
            paths[i] = copiedImages.get(i).toString();
        }
        MediaScannerConnection.scanFile((Context)context, (String[])paths, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(String path, Uri uri) {
                Log.d((String)this.getClass().getSimpleName(), (String)("Scanned " + path + ":"));
                Log.d((String)this.getClass().getSimpleName(), (String)("-> uri=" + uri));
            }
        });
    }

    static File pickedExistingPicture(@NonNull Context context, Uri photoUri) throws IOException {
        InputStream pictureInputStream = context.getContentResolver().openInputStream(photoUri);
        File directory = EasyImageFiles.tempImageDirectory(context);
        File photoFile = new File(directory, UUID.randomUUID().toString() + "." + EasyImageFiles.getMimeType(context, photoUri));
        photoFile.createNewFile();
        EasyImageFiles.writeToFile(pictureInputStream, photoFile);
        return photoFile;
    }

    static File getCameraPicturesLocation(@NonNull Context context) throws IOException {
        File dir = EasyImageFiles.tempImageDirectory(context);
        return File.createTempFile(UUID.randomUUID().toString(), ".jpg", dir);
    }

    static File getCameraVideoLocation(@NonNull Context context) throws IOException {
        File dir = EasyImageFiles.tempImageDirectory(context);
        return File.createTempFile(UUID.randomUUID().toString(), ".mp4", dir);
    }

    private static String getMimeType(@NonNull Context context, @NonNull Uri uri) {
        String extension;
        if (uri.getScheme().equals("content")) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        }
        return extension;
    }

    static Uri getUriToFile(@NonNull Context context, @NonNull File file) {
        String packageName = context.getApplicationContext().getPackageName();
        String authority = packageName + ".easyphotopicker.fileprovider";
        return FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
    }
}

