/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.content.Context;
import android.preference.PreferenceManager;
import pl.aprilapps.easyphotopicker.Constants;

public class EasyImageConfiguration
implements Constants {
    private Context context;

    EasyImageConfiguration(Context context) {
        this.context = context;
    }

    public EasyImageConfiguration setImagesFolderName(String folderName) {
        PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putString("pl.aprilapps.folder_name", folderName).commit();
        return this;
    }

    public EasyImageConfiguration setAllowMultiplePickInGallery(boolean allowMultiple) {
        PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean("pl.aprilapps.easyimage.allow_multiple", allowMultiple).commit();
        return this;
    }

    public EasyImageConfiguration setCopyTakenPhotosToPublicGalleryAppFolder(boolean copy) {
        PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean("pl.aprilapps.easyimage.copy_taken_photos", copy).commit();
        return this;
    }

    public EasyImageConfiguration setCopyPickedImagesToPublicGalleryAppFolder(boolean copy) {
        PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean("pl.aprilapps.easyimage.copy_picked_images", copy).commit();
        return this;
    }

    public String getFolderName() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.context).getString("pl.aprilapps.folder_name", "EasyImage");
    }

    public boolean allowsMultiplePickingInGallery() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.context).getBoolean("pl.aprilapps.easyimage.allow_multiple", false);
    }

    public boolean shouldCopyTakenPhotosToPublicGalleryAppFolder() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.context).getBoolean("pl.aprilapps.easyimage.copy_taken_photos", false);
    }

    public boolean shouldCopyPickedImagesToPublicGalleryAppFolder() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.context).getBoolean("pl.aprilapps.easyimage.copy_picked_images", false);
    }
}

