/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import pl.aprilapps.easyphotopicker.Constants;
import pl.aprilapps.easyphotopicker.EasyImageConfiguration;
import pl.aprilapps.easyphotopicker.EasyImageFiles;

public class EasyImage
implements Constants {
    private static final boolean SHOW_GALLERY_IN_CHOOSER = false;
    private static final String KEY_PHOTO_URI = "pl.aprilapps.easyphotopicker.photo_uri";
    private static final String KEY_LAST_CAMERA_PHOTO = "pl.aprilapps.easyphotopicker.last_photo";
    private static final String KEY_TYPE = "pl.aprilapps.easyphotopicker.type";

    private static Uri createCameraPictureFile(@NonNull Context context) throws IOException {
        File imagePath = EasyImageFiles.getCameraPicturesLocation(context);
        Uri uri = EasyImageFiles.getUriToFile(context, imagePath);
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        editor.putString(KEY_PHOTO_URI, uri.toString());
        editor.putString(KEY_LAST_CAMERA_PHOTO, imagePath.toString());
        editor.apply();
        return uri;
    }

    private static Intent createDocumentsIntent(@NonNull Context context, int type) {
        EasyImage.storeType(context, type);
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        return intent;
    }

    private static Intent createGalleryIntent(@NonNull Context context, int type) {
        EasyImage.storeType(context, type);
        Intent intent = EasyImage.plainGalleryPickerIntent();
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", EasyImage.configuration(context).allowsMultiplePickingInGallery());
        }
        return intent;
    }

    private static Intent createCameraIntent(@NonNull Context context, int type) {
        EasyImage.storeType(context, type);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        try {
            Uri capturedImageUri = EasyImage.createCameraPictureFile(context);
            EasyImage.grantWritePermission(context, intent, capturedImageUri);
            intent.putExtra("output", (Parcelable)capturedImageUri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return intent;
    }

    private static void revokeWritePermission(@NonNull Context context, Uri uri) {
        context.revokeUriPermission(uri, 3);
    }

    private static void grantWritePermission(@NonNull Context context, Intent intent, Uri uri) {
        List resInfoList = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, uri, 3);
        }
    }

    private static Intent createChooserIntent(@NonNull Context context, @Nullable String chooserTitle, int type) throws IOException {
        return EasyImage.createChooserIntent(context, chooserTitle, false, type);
    }

    private static Intent createChooserIntent(@NonNull Context context, @Nullable String chooserTitle, boolean showGallery, int type) throws IOException {
        EasyImage.storeType(context, type);
        Uri outputFileUri = EasyImage.createCameraPictureFile(context);
        ArrayList<Intent> cameraIntents = new ArrayList<Intent>();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        PackageManager packageManager = context.getPackageManager();
        List camList = packageManager.queryIntentActivities(captureIntent, 0);
        for (ResolveInfo res : camList) {
            String packageName = res.activityInfo.packageName;
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(packageName);
            intent.putExtra("output", (Parcelable)outputFileUri);
            EasyImage.grantWritePermission(context, intent, outputFileUri);
            cameraIntents.add(intent);
        }
        Intent galleryIntent = showGallery ? EasyImage.createGalleryIntent(context, type) : EasyImage.createDocumentsIntent(context, type);
        Intent chooserIntent = Intent.createChooser((Intent)galleryIntent, (CharSequence)chooserTitle);
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", cameraIntents.toArray(new Parcelable[cameraIntents.size()]));
        return chooserIntent;
    }

    private static void storeType(@NonNull Context context, int type) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt(KEY_TYPE, type).commit();
    }

    private static int restoreType(@NonNull Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getInt(KEY_TYPE, 0);
    }

    public static void openChooserWithDocuments(Activity activity, @Nullable String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)activity, chooserTitle, type);
            activity.startActivityForResult(intent, 19308);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithDocuments(android.support.v4.app.Fragment fragment, @Nullable String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, type);
            fragment.startActivityForResult(intent, 19308);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithDocuments(Fragment fragment, @Nullable String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, type);
            fragment.startActivityForResult(intent, 19308);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithGallery(Activity activity, @Nullable String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)activity, chooserTitle, true, type);
            activity.startActivityForResult(intent, 21356);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithGallery(android.support.v4.app.Fragment fragment, @Nullable String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, true, type);
            fragment.startActivityForResult(intent, 21356);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithGallery(Fragment fragment, @Nullable String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, true, type);
            fragment.startActivityForResult(intent, 21356);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openDocuments(Activity activity, int type) {
        Intent intent = EasyImage.createDocumentsIntent((Context)activity, type);
        activity.startActivityForResult(intent, 2924);
    }

    public static void openDocuments(android.support.v4.app.Fragment fragment, int type) {
        Intent intent = EasyImage.createDocumentsIntent(fragment.getContext(), type);
        fragment.startActivityForResult(intent, 2924);
    }

    public static void openDocuments(Fragment fragment, int type) {
        Intent intent = EasyImage.createDocumentsIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 2924);
    }

    public static void openGallery(Activity activity, int type) {
        Intent intent = EasyImage.createGalleryIntent((Context)activity, type);
        activity.startActivityForResult(intent, 4972);
    }

    public static void openGallery(android.support.v4.app.Fragment fragment, int type) {
        Intent intent = EasyImage.createGalleryIntent(fragment.getContext(), type);
        fragment.startActivityForResult(intent, 4972);
    }

    public static void openGallery(Fragment fragment, int type) {
        Intent intent = EasyImage.createGalleryIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 4972);
    }

    public static void openCamera(Activity activity, int type) {
        Intent intent = EasyImage.createCameraIntent((Context)activity, type);
        activity.startActivityForResult(intent, 9068);
    }

    public static void openCamera(android.support.v4.app.Fragment fragment, int type) {
        Intent intent = EasyImage.createCameraIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 9068);
    }

    public static void openCamera(Fragment fragment, int type) {
        Intent intent = EasyImage.createCameraIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 9068);
    }

    @Nullable
    private static File takenCameraPicture(Context context) throws IOException, URISyntaxException {
        String lastCameraPhoto = PreferenceManager.getDefaultSharedPreferences((Context)context).getString(KEY_LAST_CAMERA_PHOTO, null);
        if (lastCameraPhoto != null) {
            return new File(lastCameraPhoto);
        }
        return null;
    }

    public static void handleActivityResult(int requestCode, int resultCode, Intent data, Activity activity, @NonNull Callbacks callbacks) {
        boolean isEasyImage;
        boolean bl = isEasyImage = (requestCode & 0x36C) > 0;
        if (isEasyImage && ((requestCode &= 0xFFFFBFFF) == 4972 || requestCode == 9068 || requestCode == 2924)) {
            if (resultCode == -1) {
                if (requestCode == 2924 && !EasyImage.isPhoto(data)) {
                    EasyImage.onPictureReturnedFromDocuments(data, activity, callbacks);
                } else if (requestCode == 4972 && !EasyImage.isPhoto(data)) {
                    EasyImage.onPictureReturnedFromGallery(data, activity, callbacks);
                } else if (requestCode == 9068) {
                    EasyImage.onPictureReturnedFromCamera(activity, callbacks);
                } else if (EasyImage.isPhoto(data)) {
                    EasyImage.onPictureReturnedFromCamera(activity, callbacks);
                } else {
                    EasyImage.onPictureReturnedFromDocuments(data, activity, callbacks);
                }
            } else {
                callbacks.onCanceled(ImageSource.DOCUMENTS, EasyImage.restoreType((Context)activity));
                if (requestCode == 2924) {
                    callbacks.onCanceled(ImageSource.DOCUMENTS, EasyImage.restoreType((Context)activity));
                } else if (requestCode == 4972) {
                    callbacks.onCanceled(ImageSource.GALLERY, EasyImage.restoreType((Context)activity));
                } else {
                    callbacks.onCanceled(ImageSource.CAMERA, EasyImage.restoreType((Context)activity));
                }
            }
        }
    }

    private static boolean isPhoto(Intent data) {
        return data == null || data.getData() == null && data.getClipData() == null;
    }

    public static boolean willHandleActivityResult(int requestCode, int resultCode, Intent data) {
        return requestCode == 16384 || requestCode == 4972 || requestCode == 9068 || requestCode == 2924;
    }

    private static Intent plainGalleryPickerIntent() {
        return new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
    }

    public static boolean canDeviceHandleGallery(@NonNull Context context) {
        return EasyImage.plainGalleryPickerIntent().resolveActivity(context.getPackageManager()) != null;
    }

    public static File lastlyTakenButCanceledPhoto(@NonNull Context context) {
        String filePath = PreferenceManager.getDefaultSharedPreferences((Context)context).getString(KEY_LAST_CAMERA_PHOTO, null);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static void onPictureReturnedFromDocuments(Intent data, Activity activity, @NonNull Callbacks callbacks) {
        try {
            Uri photoPath = data.getData();
            File photoFile = EasyImageFiles.pickedExistingPicture((Context)activity, photoPath);
            callbacks.onImagesPicked(EasyImageFiles.singleFileList(photoFile), ImageSource.DOCUMENTS, EasyImage.restoreType((Context)activity));
            if (EasyImage.configuration((Context)activity).shouldCopyTakenPhotosToPublicGalleryAppFolder()) {
                EasyImageFiles.copyFilesInSeparateThread((Context)activity, EasyImageFiles.singleFileList(photoFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbacks.onImagePickerError(e, ImageSource.DOCUMENTS, EasyImage.restoreType((Context)activity));
        }
    }

    private static void onPictureReturnedFromGallery(Intent data, Activity activity, @NonNull Callbacks callbacks) {
        try {
            ClipData clipData = data.getClipData();
            ArrayList<File> files = new ArrayList<File>();
            if (clipData == null) {
                Uri uri = data.getData();
                File file = EasyImageFiles.pickedExistingPicture((Context)activity, uri);
                files.add(file);
            } else {
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    Uri uri = clipData.getItemAt(i).getUri();
                    File file = EasyImageFiles.pickedExistingPicture((Context)activity, uri);
                    files.add(file);
                }
            }
            if (EasyImage.configuration((Context)activity).shouldCopyTakenPhotosToPublicGalleryAppFolder()) {
                EasyImageFiles.copyFilesInSeparateThread((Context)activity, files);
            }
            callbacks.onImagesPicked(files, ImageSource.GALLERY, EasyImage.restoreType((Context)activity));
        }
        catch (Exception e) {
            e.printStackTrace();
            callbacks.onImagePickerError(e, ImageSource.GALLERY, EasyImage.restoreType((Context)activity));
        }
    }

    private static void onPictureReturnedFromCamera(Activity activity, @NonNull Callbacks callbacks) {
        try {
            String lastImageUri = PreferenceManager.getDefaultSharedPreferences((Context)activity).getString(KEY_PHOTO_URI, null);
            if (!TextUtils.isEmpty((CharSequence)lastImageUri)) {
                EasyImage.revokeWritePermission((Context)activity, Uri.parse((String)lastImageUri));
            }
            File photoFile = EasyImage.takenCameraPicture((Context)activity);
            ArrayList<File> files = new ArrayList<File>();
            files.add(photoFile);
            if (photoFile == null) {
                IllegalStateException e = new IllegalStateException("Unable to get the picture returned from camera");
                callbacks.onImagePickerError(e, ImageSource.CAMERA, EasyImage.restoreType((Context)activity));
            } else {
                if (EasyImage.configuration((Context)activity).shouldCopyTakenPhotosToPublicGalleryAppFolder()) {
                    EasyImageFiles.copyFilesInSeparateThread((Context)activity, EasyImageFiles.singleFileList(photoFile));
                }
                callbacks.onImagesPicked(files, ImageSource.CAMERA, EasyImage.restoreType((Context)activity));
            }
            PreferenceManager.getDefaultSharedPreferences((Context)activity).edit().remove(KEY_LAST_CAMERA_PHOTO).remove(KEY_PHOTO_URI).apply();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbacks.onImagePickerError(e, ImageSource.CAMERA, EasyImage.restoreType((Context)activity));
        }
    }

    public static void clearConfiguration(@NonNull Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().remove("pl.aprilapps.folder_name").remove("pl.aprilapps.easyimage.allow_multiple").remove("pl.aprilapps.easyimage.copy_taken_photos").remove("pl.aprilapps.easyimage.copy_picked_images").apply();
    }

    public static EasyImageConfiguration configuration(@NonNull Context context) {
        return new EasyImageConfiguration(context);
    }

    public static interface Callbacks {
        public void onImagePickerError(Exception var1, ImageSource var2, int var3);

        public void onImagesPicked(@NonNull List<File> var1, ImageSource var2, int var3);

        public void onCanceled(ImageSource var1, int var2);
    }

    public static enum ImageSource {
        GALLERY,
        DOCUMENTS,
        CAMERA;

    }
}

