/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

class EasyImageFiles {
    public static String DEFAULT_FOLDER_NAME = "EasyImage";
    public static String TEMP_FOLDER_NAME = "Temp";

    EasyImageFiles() {
    }

    public static String getFolderName(@NonNull Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString("pl.aprilapps.folder_name", DEFAULT_FOLDER_NAME);
    }

    public static File tempImageDirectory(@NonNull Context context) {
        File dir;
        boolean publicTemp = PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("pl.aprilapps.public_temp", false);
        File file = dir = publicTemp ? EasyImageFiles.publicTempDir(context) : EasyImageFiles.privateTempDir(context);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File publicRootDir(@NonNull Context context) {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
    }

    public static File publicAppExternalDir(@NonNull Context context) {
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    public static File publicTempDir(@NonNull Context context) {
        File cameraPicturesDir = new File(EasyImageFiles.getFolderLocation(context), EasyImageFiles.getFolderName(context));
        File publicTempDir = new File(cameraPicturesDir, TEMP_FOLDER_NAME);
        if (!publicTempDir.exists()) {
            publicTempDir.mkdirs();
        }
        return publicTempDir;
    }

    private static File privateTempDir(@NonNull Context context) {
        File privateTempDir = new File(context.getApplicationContext().getCacheDir(), EasyImageFiles.getFolderName(context));
        if (!privateTempDir.exists()) {
            privateTempDir.mkdirs();
        }
        return privateTempDir;
    }

    public static void writeToFile(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File pickedExistingPicture(@NonNull Context context, Uri photoUri) throws IOException {
        InputStream pictureInputStream = context.getContentResolver().openInputStream(photoUri);
        File directory = EasyImageFiles.tempImageDirectory(context);
        File photoFile = new File(directory, UUID.randomUUID().toString() + "." + EasyImageFiles.getMimeType(context, photoUri));
        photoFile.createNewFile();
        EasyImageFiles.writeToFile(pictureInputStream, photoFile);
        return photoFile;
    }

    public static String getFolderLocation(@NonNull Context context) {
        File publicAppExternalDir = EasyImageFiles.publicAppExternalDir(context);
        String defaultFolderLocation = null;
        if (publicAppExternalDir != null) {
            defaultFolderLocation = publicAppExternalDir.getPath();
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString("pl.aprilapps.folder_location", defaultFolderLocation);
    }

    public static File getCameraPicturesLocation(@NonNull Context context) throws IOException {
        File dir;
        File cacheDir = context.getCacheDir();
        if (EasyImageFiles.isExternalStorageWritable()) {
            cacheDir = context.getExternalCacheDir();
        }
        if (!(dir = new File(cacheDir, DEFAULT_FOLDER_NAME)).exists()) {
            dir.mkdirs();
        }
        File imageFile = File.createTempFile(UUID.randomUUID().toString(), ".jpg", dir);
        return imageFile;
    }

    private static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static String getMimeType(@NonNull Context context, @NonNull Uri uri) {
        String extension;
        if (uri.getScheme().equals("content")) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        }
        return extension;
    }
}

