/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import pl.aprilapps.easyphotopicker.EasyImageConfig;
import pl.aprilapps.easyphotopicker.EasyImageFiles;

public class EasyImage
implements EasyImageConfig {
    private static final boolean SHOW_GALLERY_IN_CHOOSER = false;
    private static final String KEY_PHOTO_URI = "pl.aprilapps.easyphotopicker.photo_uri";
    private static final String KEY_LAST_CAMERA_PHOTO = "pl.aprilapps.easyphotopicker.last_photo";
    private static final String KEY_TYPE = "pl.aprilapps.easyphotopicker.type";

    private static Uri createCameraPictureFile(Context context) throws IOException {
        File imagePath = EasyImageFiles.getCameraPicturesLocation(context);
        Uri uri = Uri.fromFile((File)imagePath);
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        editor.putString(KEY_PHOTO_URI, uri.toString());
        editor.putString(KEY_LAST_CAMERA_PHOTO, imagePath.toString());
        editor.apply();
        return uri;
    }

    private static Intent createDocumentsIntent(Context context, int type) {
        EasyImage.storeType(context, type);
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        return intent;
    }

    private static Intent createGalleryIntent(Context context, int type) {
        EasyImage.storeType(context, type);
        return new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
    }

    private static Intent createCameraIntent(Context context, int type) {
        EasyImage.storeType(context, type);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        try {
            Uri capturedImageUri = EasyImage.createCameraPictureFile(context);
            intent.putExtra("output", (Parcelable)capturedImageUri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return intent;
    }

    private static Intent createChooserIntent(Context context, String chooserTitle, int type) throws IOException {
        return EasyImage.createChooserIntent(context, chooserTitle, false, type);
    }

    private static Intent createChooserIntent(Context context, String chooserTitle, boolean showGallery, int type) throws IOException {
        EasyImage.storeType(context, type);
        Uri outputFileUri = EasyImage.createCameraPictureFile(context);
        ArrayList<Intent> cameraIntents = new ArrayList<Intent>();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        PackageManager packageManager = context.getPackageManager();
        List camList = packageManager.queryIntentActivities(captureIntent, 0);
        for (ResolveInfo res : camList) {
            String packageName = res.activityInfo.packageName;
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(packageName);
            intent.putExtra("output", (Parcelable)outputFileUri);
            cameraIntents.add(intent);
        }
        Intent galleryIntent = showGallery ? EasyImage.createGalleryIntent(context, type) : EasyImage.createDocumentsIntent(context, type);
        Intent chooserIntent = Intent.createChooser((Intent)galleryIntent, (CharSequence)chooserTitle);
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", cameraIntents.toArray(new Parcelable[cameraIntents.size()]));
        return chooserIntent;
    }

    private static void storeType(Context context, int type) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt(KEY_TYPE, type).commit();
    }

    public static void openChooserWithDocuments(Activity activity, String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)activity, chooserTitle, type);
            activity.startActivityForResult(intent, 7460);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithDocuments(android.support.v4.app.Fragment fragment, String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, type);
            fragment.startActivityForResult(intent, 7460);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithDocuments(Fragment fragment, String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, type);
            fragment.startActivityForResult(intent, 7460);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithGallery(Activity activity, String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)activity, chooserTitle, true, type);
            activity.startActivityForResult(intent, 7460);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithGallery(android.support.v4.app.Fragment fragment, String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, true, type);
            fragment.startActivityForResult(intent, 7460);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openChooserWithGallery(Fragment fragment, String chooserTitle, int type) {
        try {
            Intent intent = EasyImage.createChooserIntent((Context)fragment.getActivity(), chooserTitle, true, type);
            fragment.startActivityForResult(intent, 7460);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openDocuments(Activity activity, int type) {
        Intent intent = EasyImage.createDocumentsIntent((Context)activity, type);
        activity.startActivityForResult(intent, 7457);
    }

    public static void openDocuments(android.support.v4.app.Fragment fragment, int type) {
        Intent intent = EasyImage.createDocumentsIntent(fragment.getContext(), type);
        fragment.startActivityForResult(intent, 7457);
    }

    public static void openDocuments(Fragment fragment, int type) {
        Intent intent = EasyImage.createDocumentsIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 7457);
    }

    public static void openGallery(Activity activity, int type) {
        Intent intent = EasyImage.createGalleryIntent((Context)activity, type);
        activity.startActivityForResult(intent, 7458);
    }

    public static void openGallery(android.support.v4.app.Fragment fragment, int type) {
        Intent intent = EasyImage.createGalleryIntent(fragment.getContext(), type);
        fragment.startActivityForResult(intent, 7458);
    }

    public static void openGallery(Fragment fragment, int type) {
        Intent intent = EasyImage.createGalleryIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 7458);
    }

    public static void openCamera(Activity activity, int type) {
        Intent intent = EasyImage.createCameraIntent((Context)activity, type);
        activity.startActivityForResult(intent, 7459);
    }

    public static void openCamera(android.support.v4.app.Fragment fragment, int type) {
        Intent intent = EasyImage.createCameraIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 7459);
    }

    public static void openCamera(Fragment fragment, int type) {
        Intent intent = EasyImage.createCameraIntent((Context)fragment.getActivity(), type);
        fragment.startActivityForResult(intent, 7459);
    }

    private static File takenCameraPicture(Context context) throws IOException, URISyntaxException {
        URI imageUri = new URI(PreferenceManager.getDefaultSharedPreferences((Context)context).getString(KEY_PHOTO_URI, null));
        EasyImage.notifyGallery(context, imageUri);
        return new File(imageUri);
    }

    private static void notifyGallery(Context context, URI pictureUri) throws URISyntaxException {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File f = new File(pictureUri);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    public static void handleActivityResult(int requestCode, int resultCode, Intent data, Activity activity, Callbacks callbacks) {
        if (requestCode == 7460 || requestCode == 7458 || requestCode == 7459 || requestCode == 7457) {
            if (resultCode == -1) {
                if (requestCode == 7457) {
                    EasyImage.onPictureReturnedFromDocuments(data, activity, callbacks);
                } else if (requestCode == 7458) {
                    EasyImage.onPictureReturnedFromGallery(data, activity, callbacks);
                } else if (requestCode == 7459) {
                    EasyImage.onPictureReturnedFromCamera(activity, callbacks);
                } else if (data == null || data.getData() == null) {
                    EasyImage.onPictureReturnedFromCamera(activity, callbacks);
                } else {
                    EasyImage.onPictureReturnedFromDocuments(data, activity, callbacks);
                }
            } else if (requestCode == 7457) {
                callbacks.onCanceled(ImageSource.DOCUMENTS);
            } else if (requestCode == 7458) {
                callbacks.onCanceled(ImageSource.GALLERY);
            } else if (requestCode == 7459) {
                callbacks.onCanceled(ImageSource.CAMERA);
            } else if (data == null || data.getData() == null) {
                callbacks.onCanceled(ImageSource.CAMERA);
            } else {
                callbacks.onCanceled(ImageSource.DOCUMENTS);
            }
        }
    }

    public static File lastlyTakenButCanceledPhoto(Context context) {
        String filePath = PreferenceManager.getDefaultSharedPreferences((Context)context).getString(KEY_LAST_CAMERA_PHOTO, null);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static void onPictureReturnedFromDocuments(Intent data, Activity activity, Callbacks callbacks) {
        try {
            Uri photoPath = data.getData();
            File photoFile = EasyImageFiles.pickedExistingPicture((Context)activity, photoPath);
            callbacks.onImagePicked(photoFile, ImageSource.DOCUMENTS);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbacks.onImagePickerError(e, ImageSource.DOCUMENTS);
        }
    }

    private static void onPictureReturnedFromGallery(Intent data, Activity activity, Callbacks callbacks) {
        try {
            Uri photoPath = data.getData();
            File photoFile = EasyImageFiles.pickedExistingPicture((Context)activity, photoPath);
            callbacks.onImagePicked(photoFile, ImageSource.GALLERY);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbacks.onImagePickerError(e, ImageSource.GALLERY);
        }
    }

    private static void onPictureReturnedFromCamera(Activity activity, Callbacks callbacks) {
        try {
            File photoFile = EasyImage.takenCameraPicture((Context)activity);
            callbacks.onImagePicked(photoFile, ImageSource.CAMERA);
            PreferenceManager.getDefaultSharedPreferences((Context)activity).edit().remove(KEY_LAST_CAMERA_PHOTO).commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbacks.onImagePickerError(e, ImageSource.CAMERA);
        }
    }

    public static void clearPublicTemp(Context context) {
        File[] files;
        ArrayList tempFiles = new ArrayList();
        for (File file : files = EasyImageFiles.publicTempDir(context).listFiles()) {
            file.delete();
        }
    }

    public static void clearConfiguration(Context context) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().remove("pl.aprilapps.folder_name").remove("pl.aprilapps.folder_location").remove("pl.aprilapps.public_temp").apply();
    }

    public static Configuration configuration(Context context) {
        return new Configuration(context);
    }

    public static class Configuration {
        private Context context;

        private Configuration(Context context) {
            this.context = context;
        }

        public Configuration setImagesFolderName(String folderName) {
            PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putString("pl.aprilapps.folder_name", folderName).commit();
            return this;
        }

        public Configuration saveInRootPicturesDirectory() {
            PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putString("pl.aprilapps.folder_location", EasyImageFiles.publicRootDir(this.context).toString()).commit();
            return this;
        }

        public Configuration saveInAppExternalFilesDir() {
            PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putString("pl.aprilapps.folder_location", EasyImageFiles.publicAppExternalDir(this.context).toString()).commit();
            return this;
        }

        public Configuration setCopyExistingPicturesToPublicLocation(boolean copyToPublicLocation) {
            PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean("pl.aprilapps.public_temp", copyToPublicLocation).commit();
            return this;
        }
    }

    public static interface Callbacks {
        public void onImagePickerError(Exception var1, ImageSource var2);

        public void onImagePicked(File var1, ImageSource var2);

        public void onCanceled(ImageSource var1);
    }

    public static enum ImageSource {
        GALLERY,
        DOCUMENTS,
        CAMERA;

    }
}

