/*
 * Decompiled with CFR 0.152.
 */
package pl.aprilapps.easyphotopicker;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

class EasyImageFiles {
    public static String DEFAULT_FOLDER_NAME = "EasyImage";
    public static String TEMP_FOLDER_NAME = "Temp";

    EasyImageFiles() {
    }

    public static String getFolderName(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString("pl.aprilapps.folder_name", DEFAULT_FOLDER_NAME);
    }

    public static File tempImageDirectory(Context context) {
        File dir;
        boolean publicTemp = PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("pl.aprilapps.public_temp", false);
        File file = dir = publicTemp ? EasyImageFiles.publicTemplDir(context) : EasyImageFiles.privateTemplDir(context);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File publicRootDir(Context context) {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
    }

    public static File publicAppExternalDir(Context context) {
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    public static File publicTemplDir(Context context) {
        File cameraPicturesDir = new File(EasyImageFiles.getFolderLocation(context), EasyImageFiles.getFolderName(context));
        File publicTempDir = new File(cameraPicturesDir, TEMP_FOLDER_NAME);
        if (!publicTempDir.exists()) {
            publicTempDir.mkdirs();
        }
        return publicTempDir;
    }

    private static File privateTemplDir(Context context) {
        return new File(context.getApplicationContext().getCacheDir(), EasyImageFiles.getFolderName(context));
    }

    public static void writeToFile(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File pickedExistingPicture(Context context, Uri photoUri) throws IOException {
        InputStream pictureInputStream = context.getContentResolver().openInputStream(photoUri);
        File directory = EasyImageFiles.tempImageDirectory(context);
        File photoFile = new File(directory, UUID.randomUUID().toString());
        photoFile.createNewFile();
        EasyImageFiles.writeToFile(pictureInputStream, photoFile);
        return photoFile;
    }

    public static String getFolderLocation(Context context) {
        String defaultFolderLocation = EasyImageFiles.publicAppExternalDir(context).getPath();
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString("pl.aprilapps.folder_location", defaultFolderLocation);
    }

    public static File getCameraPicturesLocation(Context context) throws IOException {
        File dir = new File(EasyImageFiles.getFolderLocation(context), EasyImageFiles.getFolderName(context));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File imageFile = File.createTempFile(UUID.randomUUID().toString(), ".jpg", dir);
        return imageFile;
    }
}

