/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.mwa.mail;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class MailModule {
    public static final String SMTP_SENDPARTIAL = "mail.smtp.sendpartial";
    public static final String SMTP_ENVELOP_FROM = "mail.smtp.from";
    public static final String SMTP_HOST = "mail.smtp.host";
    public static final String SMTP_PORT = "mail.smtp.port";
    public static final String SMTP_DSN_NOTIFY = "mail.smtp.dsn.notify";
    public static final String SMTP_DSN_RET = "mail.smtp.dsn.ret";
    public static final String SMTP_ALLOW_8BIT_MIME = "mail.smtp.allow8bitmime";
    public static final String MAIL_USER = "mail.user";
    public static final String MAIL_PASSWORD = "mail.password";
    public static final String SMTP_AUTH = "mail.smtp.auth";
    public static final String SMTP_START_TLS = "mail.smtp.starttls.enable";
    private static final Logger logger = LoggerFactory.getLogger(MailModule.class);

    @Bean
    public JavaMailSender javaMailSender(Environment environment) {
        Validate.notNull((Object)environment, (String)"The environment is required.", (Object[])new Object[0]);
        Properties properties = new Properties();
        String host = environment.getRequiredProperty(SMTP_HOST);
        properties.setProperty(SMTP_HOST, host);
        logger.debug("{}: {}", (Object)SMTP_HOST, (Object)host);
        this.setPropertyIfPresent(SMTP_PORT, environment, properties);
        String sendPartial = environment.getProperty(SMTP_SENDPARTIAL, "true");
        properties.setProperty(SMTP_SENDPARTIAL, sendPartial);
        logger.debug("{}: {}", (Object)SMTP_SENDPARTIAL, (Object)sendPartial);
        this.setPropertyIfPresent(SMTP_ALLOW_8BIT_MIME, environment, properties);
        this.setPropertyIfPresent(SMTP_DSN_NOTIFY, environment, properties);
        this.setPropertyIfPresent(SMTP_DSN_RET, environment, properties);
        this.setPropertyIfPresent(SMTP_ENVELOP_FROM, environment, properties);
        this.setPropertyIfPresent(SMTP_START_TLS, environment, properties);
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        String user = environment.getProperty(MAIL_USER);
        if (StringUtils.isNotBlank((CharSequence)user)) {
            logger.debug("{}: {}", (Object)MAIL_USER, (Object)user);
            String password = environment.getRequiredProperty(MAIL_PASSWORD);
            logger.debug("{}: {}", (Object)MAIL_PASSWORD, (Object)password.replaceAll(".", "\\*"));
            properties.setProperty(MAIL_USER, user);
            properties.setProperty(SMTP_AUTH, "true");
            logger.debug("{}: {}", (Object)SMTP_AUTH, (Object)properties.getProperty(SMTP_AUTH));
            properties.setProperty(MAIL_PASSWORD, password);
            sender.setUsername(user);
            sender.setPassword(password);
        }
        sender.setJavaMailProperties(properties);
        return sender;
    }

    private void setPropertyIfPresent(String propertyName, Environment source, Properties destination) {
        String propertyValue = source.getProperty(propertyName);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            destination.setProperty(propertyName, propertyValue);
            logger.debug("{}: {}", (Object)propertyName, (Object)propertyValue);
        }
    }
}

