/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.mwa.mail;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.EnumSet;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.web.util.UriComponentsBuilder;

public class MailBuilder {
    private final MimeMessageHelper message;
    private static final Logger logger = LoggerFactory.getLogger(MailBuilder.class);
    private static final String cid = "cid:";

    private MailBuilder(MimeMessageHelper message) throws MessagingException {
        this.message = message;
    }

    public MailBuilder text(String text, Object ... args) throws MessagingException {
        String formattedText = MessageFormat.format(text, MailBuilder.processArgs(args));
        this.message.setText(formattedText);
        logger.debug("mail-body: {}", (Object)formattedText);
        return this;
    }

    public MailBuilder to(String ... to) throws MessagingException {
        logger.debug("mail-to: {}", (Object)Joiner.on((String)", ").join((Object[])to));
        this.message.setTo(to);
        return this;
    }

    public MailBuilder to(Iterable<String> to) throws MessagingException {
        return this.to((String[])Iterables.toArray(to, String.class));
    }

    public MailBuilder bcc(String ... bcc) throws MessagingException {
        logger.debug("mail-bcc: {}", (Object)Joiner.on((String)",").join((Object[])bcc));
        this.message.setBcc(bcc);
        return this;
    }

    public MailBuilder bcc(Iterable<String> bcc) throws MessagingException {
        return this.bcc((String[])Iterables.toArray(bcc, String.class));
    }

    public MailBuilder cc(String ... cc) throws MessagingException {
        logger.debug("mail-cc: {}", (Object)Joiner.on((String)",").join((Object[])cc));
        this.message.setCc(cc);
        return this;
    }

    public MailBuilder cc(Iterable<String> cc) throws MessagingException {
        return this.cc((String[])Iterables.toArray(cc, String.class));
    }

    public MailBuilder from(String from) throws MessagingException {
        logger.debug("mail-from: {}", (Object)from);
        this.message.setFrom(from);
        return this;
    }

    public MailBuilder from(String from, String name) throws MessagingException, UnsupportedEncodingException {
        this.message.setFrom(from, name);
        logger.debug("mail-from: \"{}\" <{}>", (Object)name, (Object)from);
        return this;
    }

    public MailBuilder replyTo(String replayTo) throws MessagingException {
        logger.debug("mail-replayTo: {}", (Object)replayTo);
        this.message.setReplyTo(replayTo);
        return this;
    }

    public MailBuilder replyTo(String replayTo, String name) throws MessagingException, UnsupportedEncodingException {
        logger.debug("mail-replayTo: \"{}\" <{}>", (Object)name, (Object)replayTo);
        this.message.setReplyTo(replayTo, name);
        return this;
    }

    public MailBuilder subject(String subject) throws MessagingException {
        logger.debug("mail-subject: {}", (Object)subject);
        this.message.setSubject(subject);
        return this;
    }

    public MailBuilder html(String html, Object ... args) throws MessagingException, IOException {
        Object[] msgArgs = MailBuilder.processArgs(args);
        String formattedText = MessageFormat.format(html, msgArgs);
        logger.debug("mail-body: {}", (Object)formattedText);
        this.message.setText(formattedText, true);
        for (int i = 0; i < args.length; ++i) {
            EmbeddedType embeddedType = EmbeddedType.of(args[i]);
            if (embeddedType == EmbeddedType.DEFAULT) continue;
            String contentType = null;
            if (args[i] instanceof InputStream) {
                contentType = MailBuilder.contentTypeOf((InputStream)args[i]);
            }
            embeddedType.append(this.message, ((String)msgArgs[i]).substring(cid.length()), args[i], contentType);
        }
        return this;
    }

    public MailBuilder attach(String name, File file) throws MessagingException {
        logger.debug("mail-attachment: {}={}", (Object)name, (Object)file);
        this.message.addAttachment(name, file);
        return this;
    }

    public MailBuilder attach(File file) throws MessagingException {
        logger.debug("mail-attachment: {}", (Object)file);
        this.message.addAttachment(file.getName(), file);
        return this;
    }

    public MailBuilder attach(String name, InputStream input, String contentType) throws MessagingException, IOException {
        logger.debug("mail-attachment: {}={}", (Object)name, (Object)contentType);
        this.message.addAttachment(name, (InputStreamSource)MailBuilder.toByteArrayResource(input), contentType);
        return this;
    }

    public MailBuilder attach(String name, Resource resource, String contentType) throws MessagingException {
        logger.debug("mail-attachment: {}={}", (Object)name, (Object)contentType);
        this.message.addAttachment(name, (InputStreamSource)resource, contentType);
        return this;
    }

    public MimeMessage build() {
        return this.message.getMimeMessage();
    }

    public static MailBuilder newMail(JavaMailSender sender, String encoding) throws MessagingException {
        Validate.notNull((Object)sender, (String)"The email sender is required.", (Object[])new Object[0]);
        Validate.notNull((Object)encoding, (String)"The encoding for the email text.", (Object[])new Object[0]);
        return new MailBuilder(new MimeMessageHelper(sender.createMimeMessage(), true, encoding));
    }

    public static MailBuilder newMail(JavaMailSender sender) throws MessagingException {
        Validate.notNull((Object)sender, (String)"The email sender is required.", (Object[])new Object[0]);
        return new MailBuilder(new MimeMessageHelper(sender.createMimeMessage(), true, "UTF-8"));
    }

    public static MailBuilder newSimpleMail(JavaMailSender sender) throws MessagingException {
        Validate.notNull((Object)sender, (String)"The email sender is required.", (Object[])new Object[0]);
        return new MailBuilder(new MimeMessageHelper(sender.createMimeMessage()));
    }

    private static String contentTypeOf(InputStream input) {
        if (input instanceof InputStreamWithContentType) {
            return ((InputStreamWithContentType)input).contentType;
        }
        return "application/octet-stream";
    }

    public static InputStream mailInputStream(InputStream input, String contentType) {
        Validate.notNull((Object)input, (String)"The input stream is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)contentType, (String)"The content-type is required.", (Object[])new Object[0]);
        return new InputStreamWithContentType(input, contentType);
    }

    private static ByteArrayResource toByteArrayResource(InputStream input) throws IOException {
        int b;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while (-1 != (b = input.read())) {
            output.write(b);
        }
        return new ByteArrayResource(output.toByteArray());
    }

    private static Object[] processArgs(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            EmbeddedType embeddedType;
            result[i] = embeddedType.apply((embeddedType = EmbeddedType.of(args[i])) == EmbeddedType.DEFAULT ? args[i] : "embedded" + (i + 1));
        }
        return result;
    }

    private static enum EmbeddedType {
        DEFAULT((Class)Object.class){

            @Override
            public void append(MimeMessageHelper message, String cid, Object embedded, String contentType) throws MessagingException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object apply(Object value) {
                String candidate = String.valueOf(value);
                if (candidate.startsWith("http://") || candidate.startsWith("https://")) {
                    return UriComponentsBuilder.fromHttpUrl((String)candidate).build().encode().toString();
                }
                return value;
            }
        }
        ,
        RESOURCE((Class)Resource.class){

            @Override
            public void append(MimeMessageHelper message, String id, Object embedded, String contentType) throws MessagingException {
                message.addInline(id, (Resource)embedded);
            }
        }
        ,
        FILE((Class)File.class){

            @Override
            public void append(MimeMessageHelper message, String id, Object embedded, String contentType) throws MessagingException {
                message.addInline(id, (File)embedded);
            }
        }
        ,
        INPUT_STREAM((Class)InputStream.class){

            @Override
            public void append(MimeMessageHelper message, String id, Object embedded, String contentType) throws MessagingException, IOException {
                message.addInline(id, (InputStreamSource)MailBuilder.toByteArrayResource((InputStream)embedded), contentType);
            }
        };

        private Class<?> embeddedType;

        private EmbeddedType(Class<?> embeddedType) {
            this.embeddedType = embeddedType;
        }

        public abstract void append(MimeMessageHelper var1, String var2, Object var3, String var4) throws MessagingException, IOException;

        public Object apply(Object value) {
            return MailBuilder.cid + value;
        }

        public static EmbeddedType of(Object embedded) {
            Validate.notNull((Object)embedded, (String)"Embedded object is required.", (Object[])new Object[0]);
            EnumSet<EmbeddedType> supported = EnumSet.allOf(EmbeddedType.class);
            supported.remove((Object)DEFAULT);
            for (EmbeddedType embeddedValue : supported) {
                if (!embeddedValue.embeddedType.isInstance(embedded)) continue;
                return embeddedValue;
            }
            return DEFAULT;
        }
    }

    private static class InputStreamWithContentType
    extends BufferedInputStream {
        private final String contentType;

        public InputStreamWithContentType(InputStream in, String contentType) {
            super(in);
            this.contentType = contentType;
        }
    }
}

