/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.context;

import com.github.jknack.handlebars.ValueResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MemberValueResolver<M extends Member>
implements ValueResolver {
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    @Override
    public final Object resolve(Object context, String name) {
        String key = this.key(context, name);
        Object value = this.cache.get(key);
        if (value == UNRESOLVED) {
            return value;
        }
        Member member = (Member)value;
        if (member == null) {
            member = this.find(context.getClass(), name);
            if (member == null) {
                this.cache.put(key, UNRESOLVED);
                return UNRESOLVED;
            }
            if (member instanceof AccessibleObject) {
                ((AccessibleObject)((Object)member)).setAccessible(true);
            }
            this.cache.put(key, member);
        }
        return this.invokeMember(member, context);
    }

    protected abstract M find(Class<?> var1, String var2);

    protected abstract Object invokeMember(M var1, Object var2);

    public abstract boolean matches(M var1, String var2);

    protected boolean isPublic(M member) {
        return Modifier.isPublic(member.getModifiers());
    }

    protected boolean isPrivate(M member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    protected boolean isProtected(M member) {
        return Modifier.isProtected(member.getModifiers());
    }

    protected boolean isStatic(M member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private String key(Object context, String name) {
        return context.getClass().getName() + "#" + name;
    }
}

