/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EachHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new EachHelper();
    public static final String NAME = "each";

    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        if (context == null) {
            return "";
        }
        if (context instanceof Iterable) {
            return this.iterableContext((Iterable)context, options);
        }
        return this.hashContext(context, options);
    }

    private CharSequence hashContext(Object context, Options options) throws IOException {
        Set<Map.Entry<String, Object>> propertySet = options.propertySet(context);
        StringBuilder buffer = new StringBuilder();
        Context parent = options.wrap(context);
        for (Map.Entry<String, Object> entry : propertySet) {
            Context current = Context.newContext(parent, entry.getValue()).data("key", entry.getKey());
            buffer.append(options.fn(current));
        }
        return buffer.toString();
    }

    private CharSequence iterableContext(Iterable<Object> context, Options options) throws IOException {
        StringBuilder buffer = new StringBuilder();
        if (options.isFalsy(context)) {
            buffer.append(options.inverse());
        } else {
            Iterator<Object> iterator = context.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Context parent = options.wrap(context);
                Object element = iterator.next();
                boolean first = index == 0;
                boolean even = index % 2 == 0;
                boolean last = !iterator.hasNext();
                Context current = Context.newContext(parent, element).data("index", index).data("first", first ? "first" : "").data("last", last ? "last" : "").data("odd", even ? "" : "odd").data("even", even ? "even" : "");
                buffer.append(options.fn(current));
                ++index;
            }
        }
        return buffer.toString();
    }
}

