/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Handlebars;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class TemplateLoader {
    public static final String DEFAULT_PREFIX = "/";
    public static final String DEFAULT_SUFFIX = ".hbs";
    private String prefix = "/";
    private String suffix = ".hbs";

    public Reader load(URI uri) throws IOException {
        Validate.notNull((Object)uri, (String)"The uri is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)uri.toString(), (String)"The uri is required.", (Object[])new Object[0]);
        String location = this.resolve(this.normalize(uri.toString()));
        Handlebars.debug("Loading resource: %s", location);
        Reader reader = this.read(location);
        if (reader == null) {
            throw new FileNotFoundException(location.toString());
        }
        Handlebars.debug("Resource found: %s", location);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadAsString(URI uri) throws IOException {
        BufferedReader reader = new BufferedReader(this.load(uri));
        int bufferSize = 1024;
        try {
            int len;
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder(1024);
            while ((len = ((Reader)reader).read(cbuf, 0, 1024)) != -1) {
                sb.append(cbuf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    public String resolve(String uri) {
        return this.prefix + this.normalize(uri) + this.suffix;
    }

    private String normalize(String uri) {
        if (uri.startsWith(DEFAULT_PREFIX)) {
            return uri.substring(1);
        }
        return uri;
    }

    protected abstract Reader read(String var1) throws IOException;

    public void setPrefix(String prefix) {
        this.prefix = (String)Validate.notNull((Object)prefix, (String)"A view prefix is required.", (Object[])new Object[0]);
        if (!this.prefix.endsWith(DEFAULT_PREFIX)) {
            this.prefix = this.prefix + DEFAULT_PREFIX;
        }
    }

    public void setSuffix(String suffix) {
        this.suffix = StringUtils.defaultString((String)suffix, (String)"");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

