/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.TemplateLoader;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.springmvc.HandlebarsView;
import com.github.jknack.handlebars.springmvc.MessageSourceHelper;
import com.github.jknack.handlebars.springmvc.SpringTemplateLoader;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class HandlebarsViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private Handlebars handlebars;
    private ValueResolver[] valueResolvers = ValueResolver.VALUE_RESOLVERS;

    public HandlebarsViewResolver(Class<? extends HandlebarsView> viewClass) {
        this.setViewClass(viewClass);
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setPrefix("/");
        this.setSuffix(".hbs");
    }

    public HandlebarsViewResolver() {
        this(HandlebarsView.class);
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        return this.configure((HandlebarsView)super.buildView(viewName));
    }

    protected AbstractUrlBasedView configure(HandlebarsView view) throws IOException {
        String url = view.getUrl();
        url = url.substring(this.getPrefix().length(), url.length() - this.getSuffix().length());
        view.setTemplate(this.handlebars.compile(URI.create(url)));
        view.setValueResolver(this.valueResolvers);
        return view;
    }

    protected Class<?> requiredViewClass() {
        return HandlebarsView.class;
    }

    public void afterPropertiesSet() throws Exception {
        TemplateLoader templateLoader = this.createTemplateLoader(this.getApplicationContext());
        this.handlebars = (Handlebars)Validate.notNull((Object)this.createHandlebars(templateLoader), (String)"A handlebars object is required.", (Object[])new Object[0]);
        this.configure(this.handlebars);
    }

    protected void configure(Handlebars handlebars) {
        handlebars.registerHelper("message", (Helper)new MessageSourceHelper((MessageSource)this.getApplicationContext()));
    }

    protected Handlebars createHandlebars(TemplateLoader templateLoader) {
        return new Handlebars(templateLoader);
    }

    protected TemplateLoader createTemplateLoader(ApplicationContext context) {
        SpringTemplateLoader templateLoader = new SpringTemplateLoader(context);
        templateLoader.setPrefix(this.getPrefix());
        templateLoader.setSuffix(this.getSuffix());
        return templateLoader;
    }

    public Handlebars getHandlebars() {
        if (this.handlebars == null) {
            throw new IllegalStateException("afterPropertiesSet() method hasn't been call it.");
        }
        return this.handlebars;
    }

    public void setValueResolvers(ValueResolver ... valueResolvers) {
        this.valueResolvers = (ValueResolver[])Validate.notEmpty((Object[])valueResolvers, (String)"At least one value-resolver must be present.", (Object[])new Object[0]);
    }
}

