/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.maven;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.maven.HandlebarsPlugin;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class PrecompilePlugin
extends HandlebarsPlugin {
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    private String prefix;
    @Parameter(defaultValue=".hbs")
    private String suffix = ".hbs";
    @Parameter
    private List<String> templates;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/js/helpers.js")
    private String output;
    @Parameter(defaultValue="/handlebars-v4.7.7.js")
    private String handlebarsJsFile;
    @Parameter
    private String runtime;
    @Parameter
    private boolean minimize;
    @Parameter
    private boolean amd;
    @Parameter
    private String encoding = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        FileInputStream runtimeIS;
        PrintWriter writer;
        boolean error;
        File output;
        block17: {
            Validate.notNull((Object)this.prefix, (String)"The prefix parameter is required.", (Object[])new Object[0]);
            Validate.notNull((Object)this.output, (String)"The output parameter is required.", (Object[])new Object[0]);
            File basedir = new File(this.prefix);
            output = new File(this.output);
            error = true;
            writer = null;
            runtimeIS = null;
            try {
                List<File> files;
                String realPrefix = basedir.getPath();
                Handlebars handlebars = new Handlebars((TemplateLoader)new FileTemplateLoader(basedir, this.suffix));
                handlebars.handlebarsJsFile(this.handlebarsJsFile);
                handlebars.setCharset(Charset.forName(this.encoding));
                ArrayList<CharSequence> extras = new ArrayList<CharSequence>();
                List classpathElements = this.project.getRuntimeClasspathElements();
                URL[] classpath = new URL[classpathElements.size()];
                for (int i = 0; i < classpath.length; ++i) {
                    classpath[i] = new File((String)classpathElements.get(i)).toURI().toURL();
                }
                this.i18nJs(handlebars, extras, classpath);
                this.i18n(handlebars);
                this.silentHelpers(handlebars);
                File parent = output.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                writer = new PrintWriter(output, this.encoding);
                if (this.runtime != null) {
                    runtimeIS = new FileInputStream(new File(this.runtime));
                    IOUtil.copy((InputStream)runtimeIS, (Writer)writer);
                }
                if (this.templates != null && this.templates.size() > 0) {
                    files = new ArrayList();
                    for (String templateName : this.templates) {
                        File file = FileUtils.getFile((String)(basedir + File.separator + templateName + this.suffix));
                        if (!file.exists()) continue;
                        files.add(file);
                    }
                } else {
                    files = FileUtils.getFiles((File)basedir, (String)("**/*" + this.suffix), null);
                }
                Collections.sort(files);
                this.getLog().info((CharSequence)"Compiling templates...");
                this.getLog().debug((CharSequence)"Options:");
                this.getLog().debug((CharSequence)("  output: " + output));
                this.getLog().debug((CharSequence)("  prefix: " + realPrefix));
                this.getLog().debug((CharSequence)("  suffix: " + this.suffix));
                this.getLog().debug((CharSequence)("  minimize: " + this.minimize));
                this.getLog().debug((CharSequence)("  runtime: " + this.runtime));
                if (!this.amd) {
                    writer.append("(function () {\n");
                }
                Context nullContext = Context.newContext(null);
                for (File file : files) {
                    String templateName = file.getPath().replace(realPrefix, "").replace(this.suffix, "");
                    if (templateName.startsWith(File.separator)) {
                        templateName = templateName.substring(File.separator.length());
                    }
                    templateName = templateName.replace(File.separator, "/");
                    this.getLog().debug((CharSequence)("compiling: " + templateName));
                    handlebars.compile(templateName).apply(nullContext);
                    Template template = handlebars.compileInline("{{precompile \"" + templateName + "\"}}");
                    HashMap<String, String> hash = new HashMap<String, String>();
                    hash.put("wrapper", this.amd ? "amd" : "none");
                    Options opts = new Options.Builder(handlebars, "precompile", TagType.VAR, nullContext, template).setHash(hash).build();
                    writer.append("// Source: ").append(file.getPath()).append("\n");
                    writer.append(PrecompileHelper.INSTANCE.apply((Object)templateName, opts).toString()).append("\n\n");
                }
                for (CharSequence extra : extras) {
                    writer.append(extra).append("\n");
                }
                if (!this.amd) {
                    writer.append("\n})();");
                }
                writer.flush();
                IOUtil.close((Writer)writer);
                if (this.minimize) {
                    this.minimize(output);
                }
                if (files.size() > 0) {
                    this.getLog().info((CharSequence)("  templates were saved in: " + output));
                    error = false;
                    break block17;
                }
                this.getLog().warn((CharSequence)"  no templates were found");
            }
            catch (Throwable throwable) {
                IOUtil.close(runtimeIS);
                IOUtil.close(writer);
                if (error) {
                    output.delete();
                }
                throw throwable;
            }
        }
        IOUtil.close((InputStream)runtimeIS);
        IOUtil.close((Writer)writer);
        if (error) {
            output.delete();
        }
    }

    private void silentHelpers(Handlebars handlebars) {
        handlebars.registerHelper("helperMissing", (context, options) -> null);
    }

    private void i18n(Handlebars handlebars) {
        handlebars.registerHelper(I18nHelper.i18n.name(), (Helper)new Helper<String>(){

            public Object apply(String context, Options options) throws IOException {
                return null;
            }

            public String toString() {
                return I18nHelper.i18n.name() + "-maven-plugin";
            }
        });
    }

    private void i18nJs(Handlebars handlebars, final List<CharSequence> extras, URL[] classpath) {
        handlebars.registerHelper(I18nHelper.i18nJs.name(), (Helper)new Helper<String>(){

            public Object apply(String context, Options options) throws IOException {
                StringBuilder output = new StringBuilder();
                output.append("// i18nJs output:\n");
                output.append("// register an empty i18nJs helper:\n");
                output.append(PrecompilePlugin.this.registerHelper(I18nHelper.i18nJs.name(), "I18n.locale = arguments[0] || \"" + Locale.getDefault() + "\";\nreturn '';", new String[]{"arguments"}));
                output.append("// redirect i18n helper to i18n.js:\n");
                output.append(PrecompilePlugin.this.registerHelper(I18nHelper.i18n.name(), "var key = arguments[0],\n  i18nOpts = {},\n  len = arguments.length - 1,  options = arguments[len];\nfor(var i = 1; i < len; i++) {\n  i18nOpts['arg' + (i - 1)] = arguments[i];\n}\ni18nOpts.locale = options.hash.locale;\nreturn I18n.t(key, i18nOpts);", new String[0]));
                extras.add(output);
                return null;
            }

            public String toString() {
                return I18nHelper.i18nJs.name() + "-maven-plugin";
            }
        });
    }

    private CharSequence registerHelper(String name, String body, String ... args) {
        return String.format("Handlebars.registerHelper('%s', function (%s) {\n%s\n});\n\n", name, StringUtils.join((Object[])args, (String)", "), body);
    }

    private void minimize(File output) throws IOException, MojoFailureException {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setOutputCharset(Charset.forName(this.encoding));
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        compiler.initOptions(options);
        Result result = compiler.compile(Collections.emptyList(), Arrays.asList(SourceFile.fromFile((String)output.getAbsolutePath())), options);
        if (!result.success) {
            ImmutableList errors = result.errors;
            throw new MojoFailureException(((JSError)errors.get(0)).toString());
        }
        FileUtils.fileWrite((File)output, (String)compiler.toSource());
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setAmd(boolean amd) {
        this.amd = amd;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void addTemplate(String template) {
        if (this.templates == null) {
            this.templates = new ArrayList<String>();
        }
        this.templates.add(template);
    }

    public void setHandlebarsJsFile(String handlebarsJsFile) {
        this.handlebarsJsFile = handlebarsJsFile;
    }
}

