/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.maven;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class HandlebarsPlugin
extends AbstractMojo {
    @Parameter(required=true)
    private String output;
    @Parameter
    private boolean includeRuntime;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    private String prefix;
    @Parameter(defaultValue=".hbs")
    private String suffix = ".hbs";
    @Parameter
    private boolean minimize;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Validate.notNull((Object)this.prefix, (String)"The prefix parameter is required.", (Object[])new Object[0]);
        Validate.notNull((Object)this.output, (String)"The output parameter is required.", (Object[])new Object[0]);
        File basedir = new File(this.prefix);
        File output = new File(this.output);
        boolean error = true;
        PrintWriter writer = null;
        InputStream runtimeIS = null;
        try {
            String realPrefix = basedir.getPath();
            Handlebars handlebars = new Handlebars((TemplateLoader)new FileTemplateLoader(basedir, this.suffix));
            ArrayList<CharSequence> extras = new ArrayList<CharSequence>();
            List classpathElements = this.project.getRuntimeClasspathElements();
            URL[] classpath = new URL[classpathElements.size()];
            for (int i = 0; i < classpath.length; ++i) {
                classpath[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            this.i18nJs(handlebars, extras, classpath);
            this.i18n(handlebars);
            this.silentHelpers(handlebars);
            File parent = output.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            runtimeIS = ((Object)((Object)this)).getClass().getResourceAsStream("/handlebars.runtime.js");
            writer = new PrintWriter(output);
            if (this.includeRuntime) {
                IOUtil.copy((InputStream)runtimeIS, (Writer)writer);
            }
            List files = FileUtils.getFiles((File)basedir, (String)("**/*" + this.suffix), null);
            Collections.sort(files);
            this.getLog().info((CharSequence)"Compiling templates...");
            this.getLog().debug((CharSequence)"Options:");
            this.getLog().debug((CharSequence)("  output: " + output));
            this.getLog().debug((CharSequence)("  prefix: " + realPrefix));
            this.getLog().debug((CharSequence)("  suffix: " + this.suffix));
            this.getLog().debug((CharSequence)("  minimize: " + this.minimize));
            this.getLog().debug((CharSequence)("  includeRuntime: " + this.includeRuntime));
            writer.append("(function () {\n");
            Context nullContext = Context.newContext(null);
            for (File file : files) {
                String templateName = file.getPath().replace(realPrefix, "").replace(this.suffix, "");
                if (templateName.startsWith(File.separator)) {
                    templateName = templateName.substring(File.separator.length());
                }
                templateName = templateName.replace(File.separator, "/");
                this.getLog().debug((CharSequence)("compiling: " + templateName));
                handlebars.compile(templateName).apply(nullContext);
                Template template = handlebars.compileInline("{{precompile \"" + templateName + "\"}}");
                HashMap<String, String> hash = new HashMap<String, String>();
                hash.put("wrapper", "none");
                Options opts = new Options.Builder(handlebars, TagType.VAR, nullContext, template).setHash(hash).build();
                writer.append("// Source: ").append(file.getPath()).append("\n");
                writer.append(PrecompileHelper.INSTANCE.apply((Object)templateName, opts)).append("\n\n");
            }
            for (CharSequence extra : extras) {
                writer.append(extra).append("\n");
            }
            writer.append("\n})();");
            writer.flush();
            IOUtil.close((Writer)writer);
            if (this.minimize) {
                this.minimize(output);
            }
            if (files.size() > 0) {
                this.getLog().info((CharSequence)("  templates were saved in: " + output));
                error = false;
            } else {
                this.getLog().warn((CharSequence)"  no templates were found");
            }
        }
        catch (RuntimeException ex) {
            try {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                catch (Exception ex2) {
                    throw new MojoFailureException(ex2.getMessage(), (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(runtimeIS);
                IOUtil.close(writer);
                if (!error) throw throwable;
                output.delete();
                throw throwable;
            }
        }
        IOUtil.close((InputStream)runtimeIS);
        IOUtil.close((Writer)writer);
        if (!error) return;
        output.delete();
    }

    private void silentHelpers(Handlebars handlebars) {
        handlebars.registerHelper("helperMissing", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                return null;
            }
        });
    }

    private void i18n(Handlebars handlebars) {
        handlebars.registerHelper(I18nHelper.i18n.name(), (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return null;
            }

            public String toString() {
                return I18nHelper.i18n.name() + "-maven-plugin";
            }
        });
    }

    private void i18nJs(Handlebars handlebars, final List<CharSequence> extras, final URL[] classpath) {
        handlebars.registerHelper(I18nHelper.i18nJs.name(), (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                Map hash = options.hash;
                hash.put("wrap", false);
                if (classpath.length > 0) {
                    hash.put("classLoader", new URLClassLoader(classpath, this.getClass().getClassLoader()));
                }
                Options opts = new Options.Builder(options.handlebars, options.tagType, options.context, options.fn).setHash(hash).setInverse(options.inverse).setParams(options.params).build();
                StringBuilder output = new StringBuilder();
                output.append("// i18nJs output:\n");
                output.append("// register an empty i18nJs helper:\n");
                output.append(HandlebarsPlugin.this.registerHelper(I18nHelper.i18nJs.name(), "if (arguments.length > 1) {\n  I18n.locale=arguments[0];\n}\nreturn '';", new String[]{"arguments"}));
                output.append("// redirect i18n helper to i18n.js:\n");
                output.append(HandlebarsPlugin.this.registerHelper(I18nHelper.i18n.name(), "var key = arguments[0],\n  i18nOpts = {},\n  len = arguments.length - 1,  options = arguments[len];\nfor(var i = 1; i < len; i++) {\n  i18nOpts['arg' + (i - 1)] = arguments[i];\n}\ni18nOpts.locale = options.hash.locale;\nreturn I18n.t(key, i18nOpts);", new String[0]));
                output.append(I18nHelper.i18nJs.apply((Object)context, opts));
                extras.add(output);
                return null;
            }

            public String toString() {
                return I18nHelper.i18nJs.name() + "-maven-plugin";
            }
        });
    }

    private CharSequence registerHelper(String name, String body, String ... args) {
        return String.format("Handlebars.registerHelper('%s', function (%s) {\n%s\n});\n\n", name, StringUtils.join((Object[])args, (String)", "), body);
    }

    private void minimize(File output) throws IOException, MojoFailureException {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setOutputCharset("UTF-8");
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        compiler.initOptions(options);
        Result result = compiler.compile(Collections.emptyList(), Arrays.asList(SourceFile.fromFile((File)output)), options);
        if (!result.success) {
            JSError[] errors = result.errors;
            throw new MojoFailureException(errors[0].toString());
        }
        FileUtils.fileWrite((File)output, (String)compiler.toSource());
    }

    public void setIncludeRuntime(boolean includeRuntime) {
        this.includeRuntime = includeRuntime;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

