/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.bean;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.github.jimu.msg.AriseAt;
import org.github.jimu.msg.EventManager;
import org.github.jimu.msg.bean.ConsumerMeta;
import org.github.jimu.msg.bean.EventBean;
import org.github.jimu.msg.notation.AriseProcess;
import org.github.jimu.msg.notation.Consumer;
import org.github.jimu.msg.notation.Event;
import osp.leobert.android.reportprinter.notation.Bug;
import osp.leobert.android.reportprinter.notation.ChangeLog;

@ChangeLog(version="1.3.3", changes={"add bean to describe method in component event manager"})
public class ManagerMethod {
    private static final Map<Method, ManagerMethod> methodCache = new ConcurrentHashMap<Method, ManagerMethod>();
    @NonNull
    private String ariseProcess = "";
    Class<? extends EventBean> eventClz;
    private int indexOfConsumerMate = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagerMethod parse(Method method) {
        ManagerMethod result = methodCache.get(method);
        if (result != null) {
            return result;
        }
        Map<Method, ManagerMethod> map = methodCache;
        synchronized (map) {
            result = methodCache.get(method);
            if (result == null) {
                result = Parser.parse(method);
                methodCache.put(method, result);
            }
        }
        return result;
    }

    @Bug(desc="check the mapping of the remote bridge,to see if \"\" can map to the default process")
    public void invoke(Object[] args) {
        try {
            ConsumerMeta meta = (ConsumerMeta)args[this.indexOfConsumerMate];
            String consumerProcess = meta.getProcess();
            AriseAt ariseAt = this.ariseProcess.equals(consumerProcess) ? AriseAt.local() : AriseAt.remote(this.ariseProcess);
            EventManager.getInstance().subscribe(this.eventClz, ariseAt, meta.getConsumeOn(), meta.getEventListener());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class Parser {
        final Method method;
        final Annotation[][] parameterAnnotationsArray;
        final Type[] parameterTypes;
        ManagerMethod managerMethod = new ManagerMethod();

        static ManagerMethod parse(Method method) {
            Parser parser = new Parser(method, method.getParameterAnnotations(), method.getGenericParameterTypes());
            return parser.parse();
        }

        private Parser(Method method, Annotation[][] parameterAnnotationsArray, Type[] parameterTypes) {
            this.method = method;
            this.parameterAnnotationsArray = parameterAnnotationsArray;
            this.parameterTypes = parameterTypes;
        }

        private ManagerMethod parse() {
            int pCount = this.parameterAnnotationsArray.length;
            AriseProcess from = this.method.getAnnotation(AriseProcess.class);
            if (from == null) {
                this.managerMethod.ariseProcess = "";
            } else {
                this.managerMethod.ariseProcess = from.pa();
            }
            Event eventAnno = this.method.getAnnotation(Event.class);
            if (eventAnno == null) {
                throw Parser.error(this.method, null, "missing notation of Event at the method", new Object[0]);
            }
            this.managerMethod.eventClz = eventAnno.clz();
            for (int i = 0; i < pCount; ++i) {
                Annotation[] paramAnnotation = this.parameterAnnotationsArray[i];
                if (paramAnnotation == null || paramAnnotation.length == 0) {
                    throw Parser.error(this.method, null, "missing notation for (parameter #" + (i + 1) + ")", new Object[0]);
                }
                this.parseParameter(i, paramAnnotation);
            }
            if (this.managerMethod.ariseProcess == null) {
                throw Parser.error(this.method, null, "pa in AriseProcess cannot be null", new Object[0]);
            }
            if (this.managerMethod.indexOfConsumerMate < 0) {
                throw Parser.error(this.method, null, "missing notation of Consumer", new Object[0]);
            }
            return this.managerMethod;
        }

        private void parseParameter(int i, Annotation[] paramAnnotation) {
            boolean hasFoundNotation = false;
            for (Annotation notation : paramAnnotation) {
                if (!(notation instanceof Consumer)) continue;
                this.checkMultiNotation(i, hasFoundNotation);
                hasFoundNotation = true;
                if (this.managerMethod.indexOfConsumerMate >= 0) {
                    throw Parser.error(this.method, null, "duplicate notation of Consumer", new Object[0]);
                }
                this.managerMethod.indexOfConsumerMate = i;
            }
        }

        private void checkMultiNotation(int i, boolean hasFoundNotation) {
            if (hasFoundNotation) {
                throw Parser.error(this.method, null, "cannot both notate with Event and Consumer. at param:" + (i + 1), new Object[0]);
            }
        }

        static RuntimeException error(Method method, @Nullable Throwable cause, String message, Object ... args) {
            message = String.format(message, args);
            return new IllegalArgumentException(message + "\n    for method " + method.getDeclaringClass().getSimpleName() + "." + method.getName(), cause);
        }
    }
}

