/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.executor;

import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.github.jimu.msg.EventListener;
import org.github.jimu.msg.bean.EventBean;
import org.github.jimu.msg.executor.IPoster;

public class LocalProcessBackgroundPoster
implements IPoster,
Runnable {
    private final List<Pair<EventBean, EventListener<EventBean>>> cache = new ArrayList<Pair<EventBean, EventListener<EventBean>>>();
    private boolean started = false;
    private final ExecutorService executorService;

    public LocalProcessBackgroundPoster(@NonNull ExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventBean> void postEvent(@NonNull T event, @NonNull EventListener<T> target) {
        List<Pair<EventBean, EventListener<EventBean>>> list = this.cache;
        synchronized (list) {
            Pair pair = new Pair(event, target);
            this.cache.add((Pair<EventBean, EventListener<EventBean>>)pair);
            if (!this.started) {
                this.started = true;
                this.executorService.execute(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                List<Pair<EventBean, EventListener<EventBean>>> list = this.cache;
                synchronized (list) {
                    if (!this.cache.isEmpty()) {
                        Pair<EventBean, EventListener<EventBean>> temp = this.cache.remove(0);
                        ((EventListener)temp.second).onEvent((EventBean)temp.first);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            List<Pair<EventBean, EventListener<EventBean>>> list = this.cache;
            synchronized (list) {
                this.started = false;
                throw throwable;
            }
        }
    }
}

