/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.core;

import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.support.annotation.NonNull;
import org.github.jimu.msg.bean.RemoteEventBean;

public class MessageFactory {
    public static final int WHAT_SUBSCRIBE_CROSS_PROCESS_EVENT = 9999;
    public static final int WHAT_SEND_CROSS_PROCESS_EVENT = 10000;
    public static final String BUNDLE_STR_EVENT_CLZ = "bundle_str_event_clz";
    public static final String BUNDLE_PARCEL_EVENT = "bundle_event_parcelable";

    public static Message obtainSubscribeMsg(Messenger consumerMessenger, Class eventClz) {
        Message message = Message.obtain();
        message.what = 9999;
        message.replyTo = consumerMessenger;
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_STR_EVENT_CLZ, eventClz.getName());
        message.setData(bundle);
        return message;
    }

    public static <T extends RemoteEventBean> Message obtainEventMsg(@NonNull T event) {
        Message message = Message.obtain();
        message.what = 10000;
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_STR_EVENT_CLZ, event.getClass().getName());
        bundle.putParcelable(BUNDLE_PARCEL_EVENT, event);
        message.setData(bundle);
        return message;
    }
}

