/*
 * Decompiled with CFR 0.152.
 */
package com.luojilab.component.componentlib.router.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import com.luojilab.component.componentlib.router.ui.UIRouter;
import com.luojilab.component.componentlib.router.ui.VerifyResult;

public abstract class AbsDispatcherActivity
extends AppCompatActivity {
    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.handleUriRequestFromOuter(this.getIntent().getData());
    }

    public final void onCreate(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        super.onCreate(savedInstanceState, persistentState);
        this.handleUriRequestFromOuter(this.getIntent().getData());
    }

    protected final void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.handleUriRequestFromOuter(intent.getData());
    }

    private void handleUriRequestFromOuter(Uri uri) {
        VerifyResult verifyResult;
        this.onBeforeHandle();
        if (uri == null) {
            this.onNullUri();
            return;
        }
        if (this.needTransferUri(uri)) {
            uri = this.transferUri(uri);
        }
        if ((verifyResult = UIRouter.getInstance().verifyUri(uri, null, true)).isSuccess()) {
            try {
                UIRouter.getInstance().openUri((Context)this, uri, this.generateBasicBundle());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onExceptionWhenOpenUri(uri, e);
            }
        } else {
            this.onVerifyFailed(verifyResult.getThrowable());
        }
        this.onHandled();
    }

    protected abstract boolean needTransferUri(Uri var1);

    protected abstract Uri transferUri(Uri var1);

    protected abstract void onBeforeHandle();

    protected abstract void onNullUri();

    protected abstract void onVerifyFailed(@Nullable Throwable var1);

    protected abstract void onExceptionWhenOpenUri(Uri var1, Exception var2);

    protected abstract void onHandled();

    protected Bundle generateBasicBundle() {
        return new Bundle();
    }
}

