/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.jiangdg.common.R;
import java.util.Locale;

public final class SeekBarPreference
extends Preference {
    private static int sDefaultValue = 1;
    private final int mSeekbarLayoutId;
    private final int mSeekbarId;
    private final int mLabelTvId;
    private final int mMinValue;
    private final int mMaxValue;
    private final int mDefaultValue;
    private final float mScaleValue;
    private final String mFmtStr;
    private int preferenceValue;
    private TextView mTextView;
    private final SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStopTrackingTouch(SeekBar seekBar) {
            int newValue = seekBar.getProgress();
            if (SeekBarPreference.this.callChangeListener(newValue)) {
                SeekBarPreference.this.preferenceValue = newValue + SeekBarPreference.this.mMinValue;
                SeekBarPreference.this.persistInt(SeekBarPreference.this.preferenceValue);
                SeekBarPreference.this.setValueLabel(SeekBarPreference.this.preferenceValue, false);
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            SeekBarPreference.this.setValueLabel(progress + SeekBarPreference.this.mMinValue, fromUser);
        }
    };

    public SeekBarPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SeekBarPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attribs = context.obtainStyledAttributes(attrs, R.styleable.SeekBarPreference, defStyle, 0);
        this.mSeekbarLayoutId = attribs.getResourceId(R.styleable.SeekBarPreference_seekbar_layout, R.layout.seekbar_preference);
        this.mSeekbarId = attribs.getResourceId(R.styleable.SeekBarPreference_seekbar_id, R.id.seekbar);
        this.mLabelTvId = attribs.getResourceId(R.styleable.SeekBarPreference_seekbar_label_id, R.id.seekbar_value_label);
        this.mMinValue = attribs.getInt(R.styleable.SeekBarPreference_min_value, 0);
        this.mMaxValue = attribs.getInt(R.styleable.SeekBarPreference_max_value, 100);
        this.mDefaultValue = attribs.getInt(R.styleable.SeekBarPreference_default_value, this.mMinValue);
        this.mScaleValue = attribs.getFloat(R.styleable.SeekBarPreference_scale_value, 1.0f);
        String fmt = attribs.getString(R.styleable.SeekBarPreference_value_format);
        try {
            String string2 = String.format(fmt, Float.valueOf(1.0f));
        }
        catch (Exception e) {
            fmt = "%f";
        }
        this.mFmtStr = !TextUtils.isEmpty((CharSequence)fmt) ? fmt : "%f";
        attribs.recycle();
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        if (this.mSeekbarLayoutId == 0 || this.mSeekbarId == 0) {
            return;
        }
        RelativeLayout parent = null;
        ViewGroup group = (ViewGroup)view;
        for (int i = group.getChildCount() - 1; i >= 0; --i) {
            View v = group.getChildAt(i);
            if (!(v instanceof RelativeLayout)) continue;
            parent = (RelativeLayout)v;
            break;
        }
        if (parent == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        View extraview = layoutInflater.inflate(this.mSeekbarLayoutId, group, false);
        if (extraview != null) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(3, 0x1020010);
            parent.addView(extraview, (ViewGroup.LayoutParams)params);
            SeekBar seekBar = (SeekBar)extraview.findViewById(this.mSeekbarId);
            if (seekBar != null) {
                seekBar.setMax(this.mMaxValue - this.mMinValue);
                int progress = this.preferenceValue - this.mMinValue;
                seekBar.setProgress(progress);
                seekBar.setSecondaryProgress(progress);
                seekBar.setOnSeekBarChangeListener(this.mOnSeekBarChangeListener);
                seekBar.setEnabled(this.isEnabled());
            }
            this.mTextView = (TextView)extraview.findViewById(R.id.seekbar_value_label);
            if (this.mTextView != null) {
                this.setValueLabel(this.preferenceValue, false);
                this.mTextView.setEnabled(this.isEnabled());
            }
        }
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getInt(index, this.mDefaultValue);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        try {
            this.preferenceValue = (Integer)defaultValue;
        }
        catch (Exception e) {
            this.preferenceValue = this.mDefaultValue;
        }
        if (restorePersistedValue) {
            this.preferenceValue = this.getPersistedInt(this.preferenceValue);
        }
        this.persistInt(this.preferenceValue);
    }

    private void setValueLabel(int value, boolean fromUser) {
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)this.formatValueLabel(value, fromUser));
        }
    }

    protected String formatValueLabel(int value, boolean fromUser) {
        try {
            return String.format(this.mFmtStr, Float.valueOf((float)value * this.mScaleValue));
        }
        catch (Exception e) {
            return String.format(Locale.US, "%f", Float.valueOf((float)value * this.mScaleValue));
        }
    }
}

