/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.jiangdg.common.R;

public class FrameView
extends View {
    private static final String TAG = FrameView.class.getSimpleName();
    public static final float MAX_SCALE = 10.0f;
    public static final int FRAME_TYPE_NONE = 0;
    public static final int FRAME_TYPE_FRAME = 1;
    public static final int FRAME_TYPE_CROSS_FULL = 2;
    public static final int FRAME_TYPE_CROSS_QUARTER = 3;
    public static final int FRAME_TYPE_CIRCLE = 4;
    public static final int FRAME_TYPE_CROSS_CIRCLE = 5;
    public static final int FRAME_TYPE_CIRCLE_2 = 6;
    public static final int FRAME_TYPE_CROSS_CIRCLE2 = 7;
    public static final int FRAME_TYPE_NUMS = 8;
    public static final int SCALE_TYPE_NONE = 0;
    public static final int SCALE_TYPE_INCH = 1;
    public static final int SCALE_TYPE_MM = 2;
    public static final int SCALE_TYPE_NUMS = 3;
    private static final float DEFAULT_FRAME_WIDTH_DP = 3.0f;
    private final Paint mPaint = new Paint();
    private final RectF mBoundsRect = new RectF();
    private final DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
    private final float defaultFrameWidth;
    private int mFrameType;
    private int mFrameColor;
    private float mFrameWidth;
    private int mScaleType;
    private int mScaleColor;
    private int mTickColor;
    private float mScaleWidth;
    private float mRotation;
    private float mScale;
    private float mCenterX;
    private float mCenterY;
    private float mWidth;
    private float mHeight;
    private float mRadius;
    private float mRadius2;
    private float mRadius4;
    private float mRadiusQ;

    public FrameView(Context context) {
        this(context, null, 0);
    }

    public FrameView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FrameView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.defaultFrameWidth = 3.0f * this.metrics.density;
        TypedArray attribs = context.obtainStyledAttributes(attrs, R.styleable.FrameView, defStyleAttr, 0);
        this.mFrameType = attribs.getInt(R.styleable.FrameView_frame_type, 0);
        this.mFrameWidth = attribs.getDimension(R.styleable.FrameView_frame_width, this.defaultFrameWidth);
        this.mFrameColor = attribs.getColor(R.styleable.FrameView_frame_color, -5131855);
        this.mScaleType = attribs.getInt(R.styleable.FrameView_scale_type, 0);
        this.mScaleWidth = attribs.getDimension(R.styleable.FrameView_scale_width, this.mFrameWidth);
        this.mScaleColor = attribs.getColor(R.styleable.FrameView_scale_color, this.mFrameColor);
        this.mTickColor = attribs.getColor(R.styleable.FrameView_tick_color, this.mScaleColor);
        this.mRotation = attribs.getFloat(R.styleable.FrameView_scale_rotation, 0.0f);
        this.mScale = attribs.getFloat(R.styleable.FrameView_scale_scale, 1.0f);
        attribs.recycle();
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        float w2 = this.mFrameWidth / 2.0f;
        this.mBoundsRect.set((float)this.getPaddingLeft() + w2, (float)this.getPaddingTop() + w2, (float)(this.getWidth() - this.getPaddingRight()) - w2, (float)(this.getHeight() - this.getPaddingBottom()) - w2);
        this.mCenterX = this.mBoundsRect.centerX();
        this.mCenterY = this.mBoundsRect.centerY();
        this.mWidth = this.mBoundsRect.width();
        this.mHeight = this.mBoundsRect.height();
        this.mRadius = Math.min(this.mWidth, this.mHeight) * 0.9f;
        this.mRadius2 = this.mRadius / 2.0f;
        this.mRadius4 = this.mRadius / 4.0f;
        this.mRadiusQ = (float)((double)this.mRadius4 / Math.sqrt(2.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mFrameType == 0) return;
        this.mPaint.setStrokeWidth(this.mFrameWidth);
        this.mPaint.setColor(this.mFrameColor);
        canvas.drawRect(this.mBoundsRect, this.mPaint);
        this.mPaint.setStrokeWidth(this.mScaleWidth);
        this.mPaint.setColor(this.mScaleColor);
        float centerX = this.mCenterX;
        float centerY = this.mCenterY;
        float r2 = this.mRadius2;
        float r4 = this.mRadius4;
        float rq = this.mRadiusQ;
        int saveCount = canvas.save();
        try {
            canvas.rotate(this.mRotation, centerX, centerY);
            canvas.scale(this.mScale, this.mScale, centerX, centerY);
            switch (this.mFrameType) {
                case 2: {
                    switch (this.mScaleType) {
                        case 0: {
                            canvas.drawLine(centerX, this.mBoundsRect.top, centerX, this.mBoundsRect.bottom, this.mPaint);
                            canvas.drawLine(this.mBoundsRect.left, centerY, this.mBoundsRect.right, centerY, this.mPaint);
                            return;
                        }
                        case 1: {
                            this.draw_scale_full(canvas, this.mWidth, this.mHeight, this.metrics.xdpi / 10.0f, this.metrics.ydpi / 10.0f, 10);
                            return;
                        }
                        case 2: {
                            this.draw_scale_full(canvas, this.mWidth, this.mHeight, this.metrics.xdpi / 12.7f, this.metrics.ydpi / 12.7f, 5);
                            return;
                        }
                    }
                    return;
                }
                case 3: {
                    switch (this.mScaleType) {
                        case 0: {
                            canvas.drawLine(centerX, centerY - r4, centerX, centerY + r4, this.mPaint);
                            canvas.drawLine(centerX - r4, centerY, centerX + r4, centerY, this.mPaint);
                            return;
                        }
                        case 1: {
                            this.draw_scale_full(canvas, r2, r2, this.metrics.xdpi / 10.0f, this.metrics.ydpi / 10.0f, 10);
                            return;
                        }
                        case 2: {
                            this.draw_scale_full(canvas, r2, r2, this.metrics.xdpi / 12.7f, this.metrics.ydpi / 12.7f, 5);
                            return;
                        }
                    }
                    return;
                }
                case 4: {
                    canvas.drawCircle(this.mCenterX, centerY, r4, this.mPaint);
                    return;
                }
                case 5: {
                    switch (this.mScaleType) {
                        case 0: {
                            canvas.drawLine(centerX, centerY - r4, centerX, centerY + r4, this.mPaint);
                            canvas.drawLine(centerX - r4, centerY, centerX + r4, centerY, this.mPaint);
                            break;
                        }
                        case 1: {
                            this.draw_scale_full(canvas, r2, r2, this.metrics.xdpi / 10.0f, this.metrics.ydpi / 10.0f, 10);
                            break;
                        }
                        case 2: {
                            this.draw_scale_full(canvas, r2, r2, this.metrics.xdpi / 12.7f, this.metrics.ydpi / 12.7f, 5);
                            break;
                        }
                    }
                    canvas.drawCircle(centerX, centerY, r4, this.mPaint);
                    return;
                }
                case 6: {
                    canvas.drawCircle(centerX, centerY, r4 / 2.0f, this.mPaint);
                    canvas.drawCircle(centerX, centerY, r4, this.mPaint);
                    return;
                }
                case 7: {
                    switch (this.mScaleType) {
                        case 0: {
                            canvas.drawLine(centerX, centerY - r4, centerX, centerY + r4, this.mPaint);
                            canvas.drawLine(centerX - r4, centerY, centerX + r4, centerY, this.mPaint);
                            break;
                        }
                        case 1: {
                            this.draw_scale_full(canvas, r2, r2, this.metrics.xdpi / 10.0f, this.metrics.ydpi / 10.0f, 10);
                            break;
                        }
                        case 2: {
                            this.draw_scale_full(canvas, r2, r2, this.metrics.xdpi / 12.7f, this.metrics.ydpi / 12.7f, 5);
                            break;
                        }
                    }
                    canvas.drawCircle(centerX, centerY, r4 / 2.0f, this.mPaint);
                    canvas.drawCircle(centerX, centerY, r4, this.mPaint);
                    return;
                }
            }
            return;
        }
        finally {
            canvas.restoreToCount(saveCount);
        }
    }

    private void draw_scale_full(Canvas canvas, float width, float height, float step_x, float step_y, int unit) {
        float l;
        int i;
        float centerX = this.mCenterX;
        float centerY = this.mCenterY;
        float len4 = this.mScaleWidth > this.defaultFrameWidth ? this.mScaleWidth * 4.0f : this.defaultFrameWidth * 4.0f;
        float len2 = this.mScaleWidth > this.defaultFrameWidth ? this.mScaleWidth * 2.0f : this.defaultFrameWidth * 2.0f;
        float w2 = width / 2.0f;
        float h2 = height / 2.0f;
        int nx = (int)(w2 / step_x);
        int ny = (int)(h2 / step_y);
        canvas.drawLine(centerX, centerY - h2, centerX, centerY + h2, this.mPaint);
        canvas.drawLine(centerX - w2, centerY, centerX + w2, centerY, this.mPaint);
        this.mPaint.setColor(this.mTickColor);
        for (i = 0; i < nx; ++i) {
            l = i % unit == 0 ? len4 : len2;
            float xp = centerX + (float)i * step_x;
            canvas.drawLine(xp, centerY - l, xp, centerY + l, this.mPaint);
            float xm = centerX - (float)i * step_x;
            canvas.drawLine(xm, centerY - l, xm, centerY + l, this.mPaint);
        }
        for (i = 0; i < ny; ++i) {
            l = i % unit == 0 ? len4 : len2;
            float yp = centerY + (float)i * step_y;
            canvas.drawLine(centerX - l, yp, centerX + l, yp, this.mPaint);
            float ym = centerY - (float)i * step_y;
            canvas.drawLine(centerX - l, ym, centerX + l, ym, this.mPaint);
        }
        this.mPaint.setColor(this.mScaleColor);
    }

    public void setFrameType(int type) {
        if (this.mFrameType != type && type >= 0 && type < 8) {
            this.mFrameType = type;
            this.postInvalidate();
        }
    }

    public int getFrameType() {
        return this.mFrameType;
    }

    public void setFrameColor(int cl) {
        if (this.mFrameColor != cl) {
            if (this.mFrameColor == this.mScaleColor) {
                this.setScaleColor(cl);
            }
            this.mFrameColor = cl;
            this.postInvalidate();
        }
    }

    public int getFrameColor() {
        return this.mFrameColor;
    }

    public void setFrameWidth(float width) {
        float w;
        float f = w = width <= 1.0f ? 0.0f : width;
        if (this.mFrameWidth != w && w >= 0.0f) {
            if (this.mFrameWidth == this.mScaleWidth) {
                this.setScaleWidth(w);
            }
            this.mFrameWidth = w;
            this.postInvalidate();
        }
    }

    public float getFrameWidth() {
        return this.mFrameWidth;
    }

    public void setScaleColor(int cl) {
        if (this.mScaleColor != cl) {
            if (this.mScaleColor == this.mTickColor) {
                this.setTickColor(cl);
            }
            this.mScaleColor = cl;
            this.postInvalidate();
        }
    }

    public int getScaleColor() {
        return this.mScaleColor;
    }

    public void setScaleType(int type) {
        if (this.mScaleType != type && type >= 0 && type < 3) {
            this.mScaleType = type;
            this.postInvalidate();
        }
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public void setScaleWidth(float width) {
        float w;
        float f = w = width <= 1.0f ? 0.0f : width;
        if (this.mScaleWidth != w) {
            this.mScaleWidth = w;
            this.postInvalidate();
        }
    }

    public float getScaleWidth() {
        return this.mScaleWidth;
    }

    public void setTickColor(int cl) {
        if (this.mTickColor != cl) {
            this.mTickColor = cl;
            this.postInvalidate();
        }
    }

    public int getTickColor() {
        return this.mTickColor;
    }

    public void setRotation(float degree) {
        float d;
        for (d = degree; d > 360.0f; d -= 360.0f) {
        }
        while (d < -360.0f) {
            d += 360.0f;
        }
        if (this.mRotation != d) {
            this.mRotation = d;
            this.postInvalidate();
        }
    }

    public float getRotation() {
        return this.mRotation;
    }

    public void setScale(float scale) {
        if (this.mScale != scale && scale > 0.0f && scale <= 10.0f) {
            this.mScale = scale;
            this.postInvalidate();
        }
    }

    public float getScale() {
        return this.mScale;
    }
}

