/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.PreferenceViewHolder;
import com.jiangdg.widget.ColorPickerView;
import com.jiangdg.widget.DialogPreferenceV7;

public class ColorPickerDialogPreferenceV7
extends DialogPreferenceV7 {
    private static final String TAG = ColorPickerDialogPreferenceV7.class.getSimpleName();
    private int mColor = -65536;
    private boolean changed;
    private final ColorPickerView.ColorPickerListener mColorPickerListener = new ColorPickerView.ColorPickerListener(){

        @Override
        public void onColorChanged(ColorPickerView colorPickerView, int color) {
            if (ColorPickerDialogPreferenceV7.this.mColor != color) {
                ColorPickerDialogPreferenceV7.this.mColor = color;
                ColorPickerDialogPreferenceV7.this.changed = true;
            }
        }
    };

    public ColorPickerDialogPreferenceV7(@NonNull Context context) {
        this(context, null, 0);
    }

    public ColorPickerDialogPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorPickerDialogPreferenceV7(@NonNull Context context, @NonNull AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.mColor = this.getPersistedInt(this.mColor);
    }

    @Override
    protected View onCreateDialogView() {
        ColorPickerView view = new ColorPickerView(this.getContext());
        view.setColorPickerListener(this.mColorPickerListener);
        return view;
    }

    @Override
    protected void onBindDialogView(@NonNull View view) {
        super.onBindDialogView(view);
        this.mColor = this.getPersistedInt(this.mColor);
        this.changed = false;
        if (view instanceof ColorPickerView) {
            ((ColorPickerView)view).setColor(this.mColor);
        }
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        if (positiveResult || this.changed) {
            this.setSummary(this.getSummary());
            if (this.callChangeListener(this.mColor)) {
                this.persistInt(this.mColor);
                this.notifyChanged();
            }
        }
        super.onDialogClosed(positiveResult || this.changed);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        if (defaultValue != null) {
            this.mColor = (Integer)defaultValue;
        }
        this.persistInt(this.mColor);
    }

    public int getValue() {
        return this.mColor;
    }
}

