/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.view.View;
import com.jiangdg.widget.ColorPickerView;

public class ColorPickerDialogPreference
extends DialogPreference {
    private static final String TAG = ColorPickerDialogPreference.class.getSimpleName();
    private int mColor = -65536;
    private boolean changed;
    private final ColorPickerView.ColorPickerListener mColorPickerListener = new ColorPickerView.ColorPickerListener(){

        @Override
        public void onColorChanged(ColorPickerView colorPickerView, int color) {
            if (ColorPickerDialogPreference.this.mColor != color) {
                ColorPickerDialogPreference.this.mColor = color;
                ColorPickerDialogPreference.this.changed = true;
            }
        }
    };

    public ColorPickerDialogPreference(Context context) {
        this(context, null, 0);
    }

    public ColorPickerDialogPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorPickerDialogPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        this.mColor = this.getPersistedInt(this.mColor);
    }

    protected View onCreateDialogView() {
        ColorPickerView view = new ColorPickerView(this.getContext());
        view.setColorPickerListener(this.mColorPickerListener);
        return view;
    }

    protected void onBindDialogView(View v) {
        super.onBindDialogView(v);
        this.mColor = this.getPersistedInt(this.mColor);
        this.changed = false;
        if (v instanceof ColorPickerView) {
            ((ColorPickerView)v).setColor(this.mColor);
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        if (positiveResult || this.changed) {
            this.setSummary(this.getSummary());
            if (this.callChangeListener(this.mColor)) {
                this.persistInt(this.mColor);
                this.notifyChanged();
            }
        }
        super.onDialogClosed(positiveResult || this.changed);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        if (restorePersistedValue) {
            this.mColor = this.getPersistedInt(this.mColor);
        } else {
            this.mColor = (Integer)defaultValue;
            this.persistInt(this.mColor);
        }
    }

    public int getValue() {
        return this.mColor;
    }
}

