/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.jiangdg.common.R;
import com.jiangdg.widget.IAspectRatioView;

public class AspectRatioFrameLayout
extends FrameLayout
implements IAspectRatioView {
    private double mRequestedAspect = -1.0;

    public AspectRatioFrameLayout(Context context) {
        this(context, null, 0);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectRatioFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IAspectRatioView, defStyleAttr, 0);
        try {
            this.mRequestedAspect = a.getFloat(R.styleable.IAspectRatioView_aspect_ratio, -1.0f);
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRequestedAspect > 0.0) {
            int vertPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizPadding) / (double)(initialHeight -= (vertPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDiff = this.mRequestedAspect / viewAspectRatio - 1.0;
            if (Math.abs(aspectDiff) > 0.01) {
                if (aspectDiff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mRequestedAspect);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mRequestedAspect);
                }
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += vertPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }
}

