/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.UriPermission;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import androidx.fragment.app.FragmentActivity;
import com.jiangdg.utils.BuildCheck;
import com.jiangdg.utils.StorageInfo;
import com.jiangdg.utils.UriHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

@Deprecated
public class SDUtils {
    private static final String TAG = SDUtils.class.getSimpleName();

    public static boolean handleOnResult(@NonNull Context context, int requestCode, int resultCode, Intent data, @NonNull handleOnResultDelegater delegater) {
        Uri uri;
        if (data != null && resultCode == -1 && (uri = data.getData()) != null) {
            try {
                return delegater.onResult(requestCode, uri, data);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        try {
            SDUtils.clearUri(context, SDUtils.getKey(requestCode));
            delegater.onFailed(requestCode, data);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return false;
    }

    @NonNull
    private static String getKey(int requestCode) {
        return String.format(Locale.US, "SDUtils-%d", requestCode);
    }

    private static void saveUri(@NonNull Context context, @NonNull String key, @NonNull Uri uri) {
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null) {
            pref.edit().putString(key, uri.toString()).apply();
        }
    }

    @Nullable
    private static Uri loadUri(@NonNull Context context, @NonNull String key) {
        Uri result = null;
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null && pref.contains(key)) {
            try {
                result = Uri.parse((String)pref.getString(key, null));
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    private static void clearUri(@NonNull Context context, @Nullable String key) {
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null && pref.contains(key)) {
            try {
                pref.edit().remove(key).apply();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(@NonNull Activity activity, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(@NonNull FragmentActivity activity, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime), requestCode);
        }
    }

    @Deprecated
    @TargetApi(value=19)
    public static void requestOpenDocument(@NonNull Fragment fragment, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(@NonNull androidx.fragment.app.Fragment fragment, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime), requestCode);
        }
    }

    @TargetApi(value=19)
    private static Intent prepareOpenDocumentIntent(@NonNull String mime) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mime);
        return intent;
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull Activity activity, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime, null), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull Activity activity, String mime, String defaultName, int requestCode) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime, defaultName), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull FragmentActivity activity, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime, null), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull FragmentActivity activity, String mime, String defaultName, int requestCode) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime, defaultName), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull Fragment fragment, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime, null), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull Fragment fragment, String mime, String defaultName, int requestCode) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime, defaultName), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull androidx.fragment.app.Fragment fragment, String mime, int requestCode) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime, null), requestCode);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(@NonNull androidx.fragment.app.Fragment fragment, String mime, String defaultName, int requestCode) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime, defaultName), requestCode);
        }
    }

    @TargetApi(value=19)
    private static Intent prepareCreateDocument(String mime, String defaultName) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mime);
        if (!TextUtils.isEmpty((CharSequence)defaultName)) {
            intent.putExtra("android.intent.extra.TITLE", defaultName);
        }
        return intent;
    }

    @TargetApi(value=19)
    public static boolean requestDeleteDocument(@NonNull Context context, Uri uri) {
        try {
            return BuildCheck.isKitKat() && DocumentsContract.deleteDocument((ContentResolver)context.getContentResolver(), (Uri)uri);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @TargetApi(value=19)
    public static boolean hasStorageAccess(@NonNull Context context, int requestCode) {
        Uri uri;
        boolean found = false;
        if (BuildCheck.isLollipop() && (uri = SDUtils.loadUri(context, SDUtils.getKey(requestCode))) != null) {
            List list = context.getContentResolver().getPersistedUriPermissions();
            for (UriPermission item : list) {
                if (!item.getUri().equals((Object)uri)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(@NonNull Activity activity, int requestCode) {
        if (BuildCheck.isLollipop()) {
            Uri uri = SDUtils.getStorageUri((Context)activity, requestCode);
            if (uri == null) {
                activity.startActivityForResult(SDUtils.prepareStorageAccessPermission(), requestCode);
            }
            return uri;
        }
        return null;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(@NonNull FragmentActivity activity, int requestCode) {
        if (BuildCheck.isLollipop()) {
            Uri uri = SDUtils.getStorageUri((Context)activity, requestCode);
            if (uri == null) {
                activity.startActivityForResult(SDUtils.prepareStorageAccessPermission(), requestCode);
            }
            return uri;
        }
        return null;
    }

    @Deprecated
    @TargetApi(value=21)
    public static Uri requestStorageAccess(@NonNull Fragment fragment, int requestCode) {
        Uri uri = SDUtils.getStorageUri((Context)fragment.getActivity(), requestCode);
        if (uri == null) {
            fragment.startActivityForResult(SDUtils.prepareStorageAccessPermission(), requestCode);
        }
        return uri;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(@NonNull androidx.fragment.app.Fragment fragment, int requestCode) {
        if (BuildCheck.isLollipop()) {
            Uri uri;
            FragmentActivity activity = fragment.getActivity();
            Uri uri2 = uri = activity != null ? SDUtils.getStorageUri((Context)activity, requestCode) : null;
            if (uri == null) {
                fragment.startActivityForResult(SDUtils.prepareStorageAccessPermission(), requestCode);
            }
            return uri;
        }
        return null;
    }

    @TargetApi(value=21)
    @Nullable
    public static Uri getStorageUri(@NonNull Context context, int requestCode) {
        Uri uri;
        if (BuildCheck.isLollipop() && (uri = SDUtils.loadUri(context, SDUtils.getKey(requestCode))) != null) {
            boolean found = false;
            List list = context.getContentResolver().getPersistedUriPermissions();
            for (UriPermission item : list) {
                if (!item.getUri().equals((Object)uri)) continue;
                found = true;
                break;
            }
            if (found) {
                return uri;
            }
        }
        return null;
    }

    @TargetApi(value=21)
    private static Intent prepareStorageAccessPermission() {
        return new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
    }

    @Nullable
    @TargetApi(value=21)
    public static Uri requestStorageAccessPermission(@NonNull Context context, int requestCode, Uri treeUri) {
        return SDUtils.requestStorageAccessPermission(context, requestCode, treeUri, 3);
    }

    @Nullable
    @TargetApi(value=21)
    public static Uri requestStorageAccessPermission(@NonNull Context context, int requestCode, Uri treeUri, int flags) {
        if (BuildCheck.isLollipop()) {
            context.getContentResolver().takePersistableUriPermission(treeUri, flags);
            SDUtils.saveUri(context, SDUtils.getKey(requestCode), treeUri);
            return treeUri;
        }
        return null;
    }

    @TargetApi(value=21)
    public static void releaseStorageAccessPermission(@NonNull Context context, int requestCode) {
        String key;
        Uri uri;
        if (BuildCheck.isLollipop() && (uri = SDUtils.loadUri(context, key = SDUtils.getKey(requestCode))) != null) {
            context.getContentResolver().releasePersistableUriPermission(uri, 3);
            SDUtils.clearUri(context, key);
        }
    }

    @Nullable
    public static DocumentFile getStorage(@NonNull Context context, int treeId) throws IOException {
        return SDUtils.getStorage(context, treeId, null);
    }

    @Nullable
    public static DocumentFile getStorage(@NonNull Context context, int treeId, @Nullable String dirs) throws IOException {
        Uri treeUri;
        if (BuildCheck.isLollipop() && (treeUri = SDUtils.getStorageUri(context, treeId)) != null) {
            DocumentFile tree = DocumentFile.fromTreeUri((Context)context, (Uri)treeUri);
            if (!TextUtils.isEmpty((CharSequence)dirs)) {
                String[] dir;
                for (String d : dir = dirs.split("/")) {
                    if (TextUtils.isEmpty((CharSequence)d)) continue;
                    DocumentFile t = tree.findFile(d);
                    if (t != null && t.isDirectory()) {
                        tree = t;
                        continue;
                    }
                    if (t == null) {
                        if (tree.canWrite()) {
                            tree = tree.createDirectory(d);
                            continue;
                        }
                        throw new IOException("can't create directory");
                    }
                    throw new IOException("can't create directory, file with same name already exists");
                }
            }
            return tree;
        }
        return null;
    }

    public static DocumentFile getStorage(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs) throws IOException {
        DocumentFile tree = parent;
        if (!TextUtils.isEmpty((CharSequence)dirs)) {
            String[] dir;
            for (String d : dir = dirs.split("/")) {
                if (TextUtils.isEmpty((CharSequence)d)) continue;
                DocumentFile t = tree.findFile(d);
                if (t != null && t.isDirectory()) {
                    tree = t;
                    continue;
                }
                if (t == null) {
                    if (tree.canWrite()) {
                        tree = tree.createDirectory(d);
                        continue;
                    }
                    throw new IOException("can't create directory");
                }
                throw new IOException("can't create directory, file with same name already exists");
            }
        }
        return tree;
    }

    @NonNull
    public static Collection<DocumentFile> listFiles(@NonNull Context context, @NonNull DocumentFile dir, @Nullable FileFilter filter) throws IOException {
        ArrayList<DocumentFile> result = new ArrayList<DocumentFile>();
        if (dir.isDirectory()) {
            DocumentFile[] files;
            for (DocumentFile file : files = dir.listFiles()) {
                if (filter != null && !filter.accept(file)) continue;
                result.add(file);
            }
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static StorageInfo getStorageInfo(@NonNull Context context, @NonNull DocumentFile dir) {
        String path2;
        try {
            File file;
            path2 = UriHelper.getPath(context, dir.getUri());
            if (path2 != null && (file = new File(path2)).isDirectory() && file.canRead()) {
                long total = file.getTotalSpace();
                long free = file.getFreeSpace();
                if (free < file.getUsableSpace()) {
                    free = file.getUsableSpace();
                }
                return new StorageInfo(total, free);
            }
        }
        catch (Exception path2) {
            // empty catch block
        }
        if (BuildCheck.isJellyBeanMR2()) {
            try {
                path2 = UriHelper.getPath(context, dir.getUri());
                StatFs fs = new StatFs(path2);
                return new StorageInfo(fs.getTotalBytes(), fs.getAvailableBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    @TargetApi(value=21)
    public static DocumentFile getStorageFile(@NonNull Context context, int treeId, String mime, String name) throws IOException {
        return SDUtils.getStorageFile(context, treeId, null, mime, name);
    }

    @Nullable
    @TargetApi(value=21)
    public static DocumentFile getStorageFile(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree;
        if (BuildCheck.isLollipop() && (tree = SDUtils.getStorage(context, treeId, dirs)) != null) {
            DocumentFile file = tree.findFile(name);
            if (file != null) {
                if (file.isFile()) {
                    return file;
                }
                throw new IOException("directory with same name already exists");
            }
            return tree.createFile(mime, name);
        }
        return null;
    }

    public static DocumentFile getStorageFile(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree = SDUtils.getStorage(context, parent, dirs);
        if (tree != null) {
            DocumentFile file = tree.findFile(name);
            if (file != null) {
                if (file.isFile()) {
                    return file;
                }
                throw new IOException("directory with same name already exists");
            }
            return tree.createFile(mime, name);
        }
        return null;
    }

    @TargetApi(value=21)
    public static OutputStream getStorageOutputStream(@NonNull Context context, int treeId, String mime, String name) throws IOException {
        return SDUtils.getStorageOutputStream(context, treeId, null, mime, name);
    }

    @TargetApi(value=21)
    public static OutputStream getStorageOutputStream(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree;
        if (BuildCheck.isLollipop() && (tree = SDUtils.getStorage(context, treeId, dirs)) != null) {
            DocumentFile file = tree.findFile(name);
            if (file != null) {
                if (file.isFile()) {
                    return context.getContentResolver().openOutputStream(file.getUri());
                }
                throw new IOException("directory with same name already exists");
            }
            return context.getContentResolver().openOutputStream(tree.createFile(mime, name).getUri());
        }
        throw new FileNotFoundException();
    }

    public static OutputStream getStorageOutputStream(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree = SDUtils.getStorage(context, parent, dirs);
        if (tree != null) {
            DocumentFile file = tree.findFile(name);
            if (file != null) {
                if (file.isFile()) {
                    return context.getContentResolver().openOutputStream(file.getUri());
                }
                throw new IOException("directory with same name already exists");
            }
            return context.getContentResolver().openOutputStream(tree.createFile(mime, name).getUri());
        }
        throw new FileNotFoundException();
    }

    @TargetApi(value=21)
    public static InputStream getStorageInputStream(@NonNull Context context, int treeId, String mime, String name) throws IOException {
        return SDUtils.getStorageInputStream(context, treeId, null, mime, name);
    }

    @TargetApi(value=21)
    public static InputStream getStorageInputStream(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile file;
        DocumentFile tree;
        if (BuildCheck.isLollipop() && (tree = SDUtils.getStorage(context, treeId, dirs)) != null && (file = tree.findFile(name)) != null) {
            if (file.isFile()) {
                return context.getContentResolver().openInputStream(file.getUri());
            }
            throw new IOException("directory with same name already exists");
        }
        throw new FileNotFoundException();
    }

    public static InputStream getStorageInputStream(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile file;
        DocumentFile tree = SDUtils.getStorage(context, parent, dirs);
        if (tree != null && (file = tree.findFile(name)) != null) {
            if (file.isFile()) {
                return context.getContentResolver().openInputStream(file.getUri());
            }
            throw new IOException("directory with same name already exists");
        }
        throw new FileNotFoundException();
    }

    @TargetApi(value=21)
    public static ParcelFileDescriptor getStorageFileFD(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree;
        if (BuildCheck.isLollipop() && (tree = SDUtils.getStorage(context, treeId, dirs)) != null) {
            DocumentFile file = tree.findFile(name);
            if (file != null) {
                if (file.isFile()) {
                    return context.getContentResolver().openFileDescriptor(file.getUri(), "rw");
                }
                throw new IOException("directory with same name already exists");
            }
            return context.getContentResolver().openFileDescriptor(tree.createFile(mime, name).getUri(), "rw");
        }
        throw new FileNotFoundException();
    }

    public static ParcelFileDescriptor getStorageFileFD(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree = SDUtils.getStorage(context, parent, dirs);
        if (tree != null) {
            DocumentFile file = tree.findFile(name);
            if (file != null) {
                if (file.isFile()) {
                    return context.getContentResolver().openFileDescriptor(file.getUri(), "rw");
                }
                throw new IOException("directory with same name already exists");
            }
            return context.getContentResolver().openFileDescriptor(tree.createFile(mime, name).getUri(), "rw");
        }
        throw new FileNotFoundException();
    }

    @Nullable
    @TargetApi(value=21)
    public static File createStorageDir(@NonNull Context context, int treeId) {
        DocumentFile saveTree;
        String path;
        Uri treeUri;
        if (BuildCheck.isLollipop() && (treeUri = SDUtils.getStorageUri(context, treeId)) != null && !TextUtils.isEmpty((CharSequence)(path = UriHelper.getPath(context, (saveTree = DocumentFile.fromTreeUri((Context)context, (Uri)treeUri)).getUri())))) {
            return new File(path);
        }
        return null;
    }

    @Nullable
    @TargetApi(value=21)
    public static File createStorageFile(@NonNull Context context, int treeId, String mime, String fileName) {
        return SDUtils.createStorageFile(context, SDUtils.getStorageUri(context, treeId), mime, fileName);
    }

    @Nullable
    @TargetApi(value=21)
    public static File createStorageFile(@NonNull Context context, Uri treeUri, String mime, String fileName) {
        DocumentFile saveTree;
        DocumentFile target;
        String path;
        Log.i((String)TAG, (String)("createStorageFile:" + fileName));
        if (BuildCheck.isLollipop() && treeUri != null && !TextUtils.isEmpty((CharSequence)fileName) && !TextUtils.isEmpty((CharSequence)(path = UriHelper.getPath(context, (target = (saveTree = DocumentFile.fromTreeUri((Context)context, (Uri)treeUri)).createFile(mime, fileName)).getUri())))) {
            return new File(path);
        }
        return null;
    }

    @TargetApi(value=21)
    public static int createStorageFileFD(@NonNull Context context, int treeId, String mime, String fileName) {
        Log.i((String)TAG, (String)("createStorageFileFD:" + fileName));
        return SDUtils.createStorageFileFD(context, SDUtils.getStorageUri(context, treeId), mime, fileName);
    }

    @TargetApi(value=21)
    public static int createStorageFileFD(@NonNull Context context, Uri treeUri, String mime, String fileName) {
        Log.i((String)TAG, (String)("createStorageFileFD:" + fileName));
        if (BuildCheck.isLollipop() && treeUri != null && !TextUtils.isEmpty((CharSequence)fileName)) {
            DocumentFile saveTree = DocumentFile.fromTreeUri((Context)context, (Uri)treeUri);
            DocumentFile target = saveTree.createFile(mime, fileName);
            try {
                ParcelFileDescriptor fd = context.getContentResolver().openFileDescriptor(target.getUri(), "rw");
                return fd != null ? fd.getFd() : 0;
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return 0;
    }

    public static interface FileFilter {
        public boolean accept(@NonNull DocumentFile var1);
    }

    public static interface handleOnResultDelegater {
        public boolean onResult(int var1, Uri var2, Intent var3);

        public void onFailed(int var1, Intent var2);
    }
}

