/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.NonNull;

public class ResourceHelper {
    public static int get(@NonNull Context context, String value, int defaultValue) throws Resources.NotFoundException, NumberFormatException, NullPointerException {
        int result = defaultValue;
        String v = value;
        if (!TextUtils.isEmpty((CharSequence)v) && v.startsWith("@")) {
            String r = v.substring(1);
            int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
            if (resId > 0) {
                result = context.getResources().getInteger(resId);
            }
        } else {
            int radix = 10;
            if (v != null && v.length() > 2 && v.charAt(0) == '0' && (v.charAt(1) == 'x' || v.charAt(1) == 'X')) {
                radix = 16;
                v = v.substring(2);
            }
            result = Integer.parseInt(v, radix);
        }
        return result;
    }

    public static boolean get(@NonNull Context context, String value, boolean defaultValue) throws Resources.NotFoundException, NumberFormatException, NullPointerException {
        boolean result = defaultValue;
        String v = value;
        if ("TRUE".equalsIgnoreCase(v)) {
            result = true;
        } else if ("FALSE".equalsIgnoreCase(v)) {
            result = false;
        } else if (!TextUtils.isEmpty((CharSequence)v) && v.startsWith("@")) {
            String r = v.substring(1);
            int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
            if (resId > 0) {
                result = context.getResources().getBoolean(resId);
            }
        } else {
            int val;
            int radix = 10;
            if (v != null && v.length() > 2 && v.charAt(0) == '0' && (v.charAt(1) == 'x' || v.charAt(1) == 'X')) {
                radix = 16;
                v = v.substring(2);
            }
            result = (val = Integer.parseInt(v, radix)) != 0;
        }
        return result;
    }

    public static String get(@NonNull Context context, String value, String defaultValue) throws Resources.NotFoundException, NullPointerException {
        String result = value;
        if (result == null) {
            result = defaultValue;
        }
        if (!TextUtils.isEmpty((CharSequence)result) && result.startsWith("@")) {
            String r = result.substring(1);
            int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
            if (resId > 0) {
                result = context.getResources().getString(resId);
            }
        }
        return result;
    }

    public static CharSequence get(@NonNull Context context, CharSequence value, CharSequence defaultValue) throws Resources.NotFoundException, NullPointerException {
        String s;
        CharSequence result = value;
        if (result == null) {
            result = defaultValue;
        }
        if (!TextUtils.isEmpty((CharSequence)result) && (s = result.toString()).startsWith("@")) {
            String r = s.substring(1);
            int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
            if (resId > 0) {
                result = context.getResources().getText(resId);
            }
        }
        return result;
    }
}

