/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

public class GPS {
    public static final Datum BESSEL = new Datum(6377397.155, 6356079.0, 299.152813, true);
    public static final Datum WGS84 = new Datum(6378137.0, 6356752.314245, 298.257223563, true);
    public static final Datum GRS80 = new Datum(6378137.0, 6356752.31414, 298.257222101, true);

    public static double distance(Datum datum, double latitude_degree1, double longitude_degree1, double altitude1, double latitude_degree2, double longitude_degree2, double altitude2) {
        double latitude1 = Math.toRadians(latitude_degree1);
        double latitude2 = Math.toRadians(latitude_degree2);
        double longitude1 = Math.toRadians(longitude_degree1);
        double longitude2 = Math.toRadians(longitude_degree2);
        double dy = latitude1 - latitude2;
        double dx = longitude1 - longitude2;
        double u = (latitude1 + latitude2) / 2.0;
        double sin_u = Math.sin(u);
        double w = Math.sqrt(1.0 - datum.e2 * sin_u * sin_u);
        double m = datum.ae2 / (w * w * w);
        double n = datum.a / w;
        double dm = dy * m;
        double dn = dx * n * Math.cos(u);
        return Math.sqrt(dm * dm + dn * dn);
    }

    public static class Datum {
        public final double a;
        public final double b;
        public final double inv_ellipticity;
        public final double e2;
        public final double ae2;

        public Datum(double a, double b, double ellipticity, boolean inverse) {
            this.a = a;
            this.b = b;
            this.inv_ellipticity = inverse ? ellipticity : 1.0 / ellipticity;
            double a2 = a * a;
            this.e2 = (a2 - b * b) / a2;
            this.ae2 = a * (1.0 - this.e2);
        }
    }
}

