/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediaeffect;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.jiangdg.glutils.GLHelper;
import com.jiangdg.mediaeffect.MediaEffectColorAdjustDrawer;

public class MediaEffectKernel3x3Drawer
extends MediaEffectColorAdjustDrawer {
    public static final int KERNEL_SIZE = 9;
    public static final float[] KERNEL_NULL = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] KERNEL_SOBEL_H = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
    public static final float[] KERNEL_SOBEL_V = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
    public static final float[] KERNEL_SOBEL2_H = new float[]{3.0f, 0.0f, -3.0f, 10.0f, 0.0f, -10.0f, 3.0f, 0.0f, -3.0f};
    public static final float[] KERNEL_SOBEL2_V = new float[]{3.0f, 10.0f, 3.0f, 0.0f, 0.0f, 0.0f, -3.0f, -10.0f, -3.0f};
    public static final float[] KERNEL_SHARPNESS = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static final float[] KERNEL_EDGE_DETECT = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    public static final float[] KERNEL_EMBOSS = new float[]{2.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f};
    public static final float[] KERNEL_SMOOTH = new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f};
    public static final float[] KERNEL_GAUSSIAN = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
    public static final float[] KERNEL_BRIGHTEN = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] KERNEL_LAPLACIAN = new float[]{1.0f, 1.0f, 1.0f, 1.0f, -8.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private final int muKernelLoc;
    private final int muTexOffsetLoc;
    private final float[] mKernel = new float[18];
    private final float[] mTexOffset = new float[18];
    private float mTexWidth;
    private float mTexHeight;
    private static final String FRAGMENT_SHADER_FILT3x3_BASE = "#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform float uKernel[18];\nuniform vec2  uTexOffset[KERNEL_SIZE3x3];\nuniform float uColorAdjust;\nvoid main() {\n    vec4 sum = vec4(0.0);\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[0]) * uKernel[0];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[1]) * uKernel[1];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[2]) * uKernel[2];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[3]) * uKernel[3];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[4]) * uKernel[4];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[5]) * uKernel[5];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[6]) * uKernel[6];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[7]) * uKernel[7];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[8]) * uKernel[8];\n    gl_FragColor = sum + uColorAdjust;\n}\n";
    private static final String FRAGMENT_SHADER_FILT3x3 = String.format("#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform float uKernel[18];\nuniform vec2  uTexOffset[KERNEL_SIZE3x3];\nuniform float uColorAdjust;\nvoid main() {\n    vec4 sum = vec4(0.0);\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[0]) * uKernel[0];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[1]) * uKernel[1];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[2]) * uKernel[2];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[3]) * uKernel[3];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[4]) * uKernel[4];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[5]) * uKernel[5];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[6]) * uKernel[6];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[7]) * uKernel[7];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[8]) * uKernel[8];\n    gl_FragColor = sum + uColorAdjust;\n}\n", "", "sampler2D");
    private static final String FRAGMENT_SHADER_EXT_FILT3x3 = String.format("#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform float uKernel[18];\nuniform vec2  uTexOffset[KERNEL_SIZE3x3];\nuniform float uColorAdjust;\nvoid main() {\n    vec4 sum = vec4(0.0);\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[0]) * uKernel[0];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[1]) * uKernel[1];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[2]) * uKernel[2];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[3]) * uKernel[3];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[4]) * uKernel[4];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[5]) * uKernel[5];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[6]) * uKernel[6];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[7]) * uKernel[7];\n    sum += texture2D(sTexture, vTextureCoord + uTexOffset[8]) * uKernel[8];\n    gl_FragColor = sum + uColorAdjust;\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");

    public MediaEffectKernel3x3Drawer(String fss) {
        this(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public MediaEffectKernel3x3Drawer(boolean isOES, String fss) {
        this(isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public MediaEffectKernel3x3Drawer(boolean isOES, String vss, String fss) {
        super(isOES, vss, fss);
        this.muKernelLoc = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"uKernel");
        if (this.muKernelLoc < 0) {
            this.muTexOffsetLoc = -1;
        } else {
            this.muTexOffsetLoc = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"uTexOffset");
            this.setKernel(KERNEL_NULL, 0.0f);
            this.setTexSize(256, 256);
        }
    }

    @Override
    protected void preDraw(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
        super.preDraw(tex_ids, tex_matrix, offset);
        if (this.muKernelLoc >= 0) {
            GLES20.glUniform1fv((int)this.muKernelLoc, (int)9, (float[])this.mKernel, (int)0);
            GLHelper.checkGlError("set kernel");
        }
        if (this.muTexOffsetLoc >= 0) {
            GLES20.glUniform2fv((int)this.muTexOffsetLoc, (int)9, (float[])this.mTexOffset, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKernel(float[] values, float colorAdj) {
        if (values == null || values.length < 9) {
            throw new IllegalArgumentException("Kernel size is " + (values != null ? values.length : 0) + " vs. " + 9);
        }
        Object object = this.mSync;
        synchronized (object) {
            System.arraycopy(values, 0, this.mKernel, 0, 9);
            this.setColorAdjust(colorAdj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTexSize(int width, int height) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mTexWidth != (float)width || this.mTexHeight != (float)height) {
                this.mTexHeight = height;
                this.mTexWidth = width;
                float rw = 1.0f / (float)width;
                float rh = 1.0f / (float)height;
                this.mTexOffset[0] = -rw;
                this.mTexOffset[1] = -rh;
                this.mTexOffset[2] = 0.0f;
                this.mTexOffset[3] = -rh;
                this.mTexOffset[4] = rw;
                this.mTexOffset[5] = -rh;
                this.mTexOffset[6] = -rw;
                this.mTexOffset[7] = 0.0f;
                this.mTexOffset[8] = 0.0f;
                this.mTexOffset[9] = 0.0f;
                this.mTexOffset[10] = rw;
                this.mTexOffset[11] = 0.0f;
                this.mTexOffset[12] = -rw;
                this.mTexOffset[13] = rh;
                this.mTexOffset[14] = 0.0f;
                this.mTexOffset[15] = rh;
                this.mTexOffset[16] = rw;
                this.mTexOffset[17] = rh;
            }
        }
    }
}

