/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediaeffect;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.jiangdg.mediaeffect.MediaEffectDrawer;

public class MediaEffectColorAdjustDrawer
extends MediaEffectDrawer.MediaEffectSingleDrawer {
    private int muColorAdjustLoc = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"uColorAdjust");
    private float mColorAdjust;

    public MediaEffectColorAdjustDrawer(String fss) {
        this(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public MediaEffectColorAdjustDrawer(boolean isOES, String fss) {
        this(isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public MediaEffectColorAdjustDrawer(boolean isOES, String vss, String fss) {
        super(isOES, vss, fss);
        if (this.muColorAdjustLoc < 0) {
            this.muColorAdjustLoc = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorAdjust(float adjust) {
        Object object = this.mSync;
        synchronized (object) {
            this.mColorAdjust = adjust;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preDraw(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
        super.preDraw(tex_ids, tex_matrix, offset);
        if (this.muColorAdjustLoc >= 0) {
            Object object = this.mSync;
            synchronized (object) {
                GLES20.glUniform1f((int)this.muColorAdjustLoc, (float)this.mColorAdjust);
            }
        }
    }
}

