/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.os.Build;

public class VideoConfig {
    private static float BPP = 0.25f;
    public static final float BPP_MIN = 0.01f;
    public static float BPP_MAX = 0.3f;
    public static final int FPS_MIN = 2;
    public static final int FPS_MAX = 121;
    private static float IFRAME_INTERVAL = 10.0f;
    private static final int IFRAME_MIN = 1;
    private static final int IFRAME_MAX = 30;
    private static float IFI = IFRAME_INTERVAL * 30.0f;
    private static int captureFps = 15;
    public static long maxDuration = 30000L;
    public static long repeatInterval = 60000L;
    public static int maxRepeats = 1;
    public static boolean sUseMediaMuxer;
    public static boolean sIsSurfaceCapture;

    public static void setCaptureFps(int fps) {
        captureFps = fps > 121 ? 121 : (fps < 2 ? 2 : fps);
    }

    public static int getCaptureFps() {
        return captureFps > 121 ? 121 : (captureFps < 2 ? 2 : captureFps);
    }

    public static void setIFrame(float iframe_interval) {
        IFRAME_INTERVAL = iframe_interval;
        IFI = IFRAME_INTERVAL * 30.0f;
    }

    public static final int getIFrame() {
        float iframe;
        int fps = VideoConfig.getCaptureFps();
        try {
            iframe = fps < 2 ? 1.0f : (float)Math.ceil(IFI / (float)fps);
        }
        catch (Exception e) {
            iframe = IFRAME_INTERVAL;
        }
        if ((int)iframe < 1) {
            iframe = 1.0f;
        } else if ((int)iframe > 30) {
            iframe = 30.0f;
        }
        return (int)iframe;
    }

    public static int calcBitrate(int width, int height, int frameRate, float bpp) {
        int r = (int)(Math.floor(bpp * (float)frameRate * (float)width * (float)height / 1000.0f / 100.0f) * 100.0) * 1000;
        if (r < 200000) {
            r = 200000;
        } else if (r > 20000000) {
            r = 20000000;
        }
        return r;
    }

    public static int getBitrate(int width, int height) {
        return VideoConfig.calcBitrate(width, height, VideoConfig.getCaptureFps(), BPP);
    }

    public static int getBitrate(int width, int height, int frameRate) {
        return VideoConfig.calcBitrate(width, height, frameRate, BPP);
    }

    public static int getBitrate(int width, int height, int frameRate, float bpp) {
        return VideoConfig.calcBitrate(width, height, frameRate, bpp);
    }

    public static float calcBPP(int width, int height, int captureFps, int bitrate) {
        return (float)bitrate / (float)(captureFps * width * height);
    }

    public static float calcBPP(int width, int height, int bitrate) {
        return VideoConfig.calcBPP(width, height, VideoConfig.getCaptureFps(), bitrate);
    }

    public static void setBPP(int width, int height, int bitrate) throws IllegalArgumentException {
        VideoConfig.setBPP(VideoConfig.calcBPP(width, height, bitrate));
    }

    public static void setBPP(float bpp) throws IllegalArgumentException {
        if (bpp < 0.01f || bpp > BPP_MAX) {
            throw new IllegalArgumentException("bpp should be within [BPP_MIN, BPP_MAX]");
        }
        BPP = bpp;
    }

    public static float bpp() {
        return BPP;
    }

    public static int getSizeRate(int width, int height) {
        int bitrate = VideoConfig.getBitrate(width, height);
        return bitrate * 60 / 8;
    }

    static {
        if (Build.VERSION.SDK_INT >= 18) {
            // empty if block
        }
        sUseMediaMuxer = false;
        if (Build.VERSION.SDK_INT >= 18) {
            // empty if block
        }
        sIsSurfaceCapture = false;
    }
}

