/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.text.TextUtils;
import android.view.Surface;
import com.jiangdg.media.MediaDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaVideoDecoder
extends MediaDecoder {
    private static final boolean DEBUG = false;
    private Surface mSurface;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mRotation;

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public int getRotation() {
        return this.mRotation;
    }

    @Override
    protected int handlePrepare(MediaExtractor media_extractor) {
        int track_index = MediaVideoDecoder.selectTrack(media_extractor, "video/");
        if (track_index >= 0) {
            MediaFormat format = media_extractor.getTrackFormat(track_index);
            this.mVideoWidth = format.getInteger("width");
            this.mVideoHeight = format.getInteger("height");
        }
        return track_index;
    }

    @Override
    protected MediaCodec createCodec(MediaExtractor media_extractor, int track_index, MediaFormat format) throws IOException {
        if (Build.VERSION.SDK_INT > 18) {
            format.setInteger("push-blank-buffers-on-shutdown", 1);
        }
        return super.createCodec(media_extractor, track_index, format);
    }

    public void setSurface(Surface surface) {
        this.mSurface = surface;
    }

    @Override
    protected Surface getOutputSurface() {
        IllegalArgumentException e;
        if (this.mSurface == null && !this.callErrorHandler(e = new IllegalArgumentException("need to call setSurface before prepare"))) {
            throw e;
        }
        return this.mSurface;
    }

    @Override
    protected boolean handleOutput(ByteBuffer buffer, int offset, int size, long presentationTimeUs) {
        return false;
    }

    @Override
    protected void updateMovieInfo(MediaMetadataRetriever metadata) {
        super.updateMovieInfo(metadata);
        this.mRotation = 0;
        this.mVideoHeight = 0;
        this.mVideoWidth = 0;
        String value = metadata.extractMetadata(18);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.mVideoWidth = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = metadata.extractMetadata(19)))) {
            this.mVideoHeight = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = metadata.extractMetadata(24)))) {
            this.mRotation = Integer.parseInt(value);
        }
    }
}

