/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.jiangdg.media.IMuxer;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class MediaMuxerWrapper
implements IMuxer {
    private static final String TAG = MediaMuxerWrapper.class.getSimpleName();
    private final MediaMuxer mMuxer;
    private volatile boolean mIsStarted;
    private boolean mReleased;

    public MediaMuxerWrapper(String output_path, int format) throws IOException {
        this.mMuxer = new MediaMuxer(output_path, format);
    }

    @RequiresApi(api=26)
    public MediaMuxerWrapper(FileDescriptor fd, int format) throws IOException {
        this.mMuxer = new MediaMuxer(fd, format);
    }

    @Override
    public int addTrack(@NonNull MediaFormat format) {
        return this.mMuxer.addTrack(format);
    }

    @Override
    public void writeSampleData(int trackIndex, @NonNull ByteBuffer byteBuf, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (!this.mReleased) {
            this.mMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
        }
    }

    @Override
    public void start() {
        this.mMuxer.start();
        this.mIsStarted = true;
    }

    @Override
    public void stop() {
        if (this.mIsStarted) {
            this.mIsStarted = false;
            this.mMuxer.stop();
        }
    }

    @Override
    public void release() {
        this.mIsStarted = false;
        if (!this.mReleased) {
            this.mReleased = true;
            try {
                this.mMuxer.release();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.mIsStarted && !this.mReleased;
    }
}

