/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.jiangdg.media.AbstractRecorder;
import com.jiangdg.media.IMediaCodec;
import com.jiangdg.media.IMediaCodecCallback;
import com.jiangdg.media.IMuxer;
import com.jiangdg.media.MediaAudioEncoder;
import com.jiangdg.media.MediaMuxerWrapper;
import com.jiangdg.media.MediaVideoEncoder;
import com.jiangdg.media.VideoMuxer;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class MediaMovieRecorder
extends AbstractRecorder {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaMovieRecorder";
    private final IMuxer mMuxer;
    private IRecorderCallback mRecorderCallback;
    private final boolean hasAudioEncoder;
    private final IMediaCodecCallback mMediaCodecCallback = new IMediaCodecCallback(){

        @Override
        public void onPrepared(IMediaCodec codec) {
            boolean isPrepared;
            boolean bl = isPrepared = MediaMovieRecorder.this.mVideoEncoder.isPrepared() && (!MediaMovieRecorder.this.hasAudioEncoder || MediaMovieRecorder.this.mAudioEncoder.isPrepared());
            if (isPrepared && MediaMovieRecorder.this.mRecorderCallback != null) {
                try {
                    MediaMovieRecorder.this.mRecorderCallback.onPrepared(MediaMovieRecorder.this);
                }
                catch (Exception e) {
                    Log.w((String)MediaMovieRecorder.TAG, (Throwable)e);
                }
            }
        }

        @Override
        public void onStart(IMediaCodec codec) {
            boolean isStarted;
            boolean bl = isStarted = MediaMovieRecorder.this.mVideoEncoder.isRunning() && (!MediaMovieRecorder.this.hasAudioEncoder || MediaMovieRecorder.this.mAudioEncoder.isRunning());
            if (isStarted && MediaMovieRecorder.this.mRecorderCallback != null) {
                try {
                    MediaMovieRecorder.this.mRecorderCallback.onStart(MediaMovieRecorder.this);
                }
                catch (Exception e) {
                    Log.w((String)MediaMovieRecorder.TAG, (Throwable)e);
                }
            }
        }

        @Override
        public boolean onFrameAvailable(IMediaCodec codec, long presentationTimeUs) {
            return false;
        }

        @Override
        public void onStop(IMediaCodec codec) {
            if (MediaMovieRecorder.this.mRecorderCallback != null) {
                try {
                    MediaMovieRecorder.this.mRecorderCallback.onStop(MediaMovieRecorder.this);
                    MediaMovieRecorder.this.release();
                }
                catch (Exception e) {
                    Log.w((String)MediaMovieRecorder.TAG, (Throwable)e);
                }
            }
        }

        @Override
        public void onRelease(IMediaCodec codec) {
        }

        @Override
        public boolean onError(IMediaCodec codec, Exception e) {
            return false;
        }
    };

    public MediaMovieRecorder(String output_path, boolean audio_recording) throws IOException {
        this(output_path, audio_recording, false);
    }

    public MediaMovieRecorder(String output_path, boolean audio_recording, boolean useVideoMuxer) throws IOException {
        super(output_path);
        this.mMuxer = useVideoMuxer ? new VideoMuxer(output_path) : new MediaMuxerWrapper(output_path, 0);
        new MediaVideoEncoder(this, this.mMediaCodecCallback);
        if (audio_recording) {
            new MediaAudioEncoder(this, this.mMediaCodecCallback);
        }
        this.hasAudioEncoder = audio_recording;
    }

    public void setCallback(IRecorderCallback callback) {
        this.mRecorderCallback = callback;
    }

    public IRecorderCallback getCallback() {
        return this.mRecorderCallback;
    }

    public void setVideoSize(int width, int height) {
        ((MediaVideoEncoder)this.mVideoEncoder).setVideoSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.mVideoEncoder != null ? ((MediaVideoEncoder)this.mVideoEncoder).getWidth() : 0;
    }

    @Override
    public int getHeight() {
        return this.mVideoEncoder != null ? ((MediaVideoEncoder)this.mVideoEncoder).getHeight() : 0;
    }

    @Override
    public Surface getInputSurface() throws IllegalStateException {
        return ((MediaVideoEncoder)this.mVideoEncoder).getInputSurface();
    }

    @Override
    protected void internal_start() {
        this.mMuxer.start();
    }

    @Override
    protected void internal_stop() {
        this.mMuxer.stop();
        this.mMuxer.release();
    }

    @Override
    int addTrack(MediaFormat format) {
        if (this.mIsStarted) {
            throw new IllegalStateException("muxer already started");
        }
        int trackIx = this.mMuxer.addTrack(format);
        return trackIx;
    }

    @Override
    void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (this.mIsStarted) {
            this.mMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
        }
    }

    public static interface IRecorderCallback {
        public void onPrepared(MediaMovieRecorder var1);

        public void onStart(MediaMovieRecorder var1);

        public void onStop(MediaMovieRecorder var1);
    }
}

