/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MediaData {
    ByteBuffer mBuffer;
    int flags;
    int size;
    long presentationTimeUs;

    public MediaData() {
    }

    public MediaData(@IntRange(from=0L) int size) {
        this.resize(size);
    }

    public void set(@NonNull ByteBuffer buffer, @IntRange(from=0L) int size, long presentationTimeUs) {
        this.set(buffer, 0, size, presentationTimeUs, 0);
    }

    public void set(@Nullable ByteBuffer buffer, @IntRange(from=0L) int _offset, @IntRange(from=0L) int _size, long _presentationTimeUs, int _flags) {
        this.presentationTimeUs = _presentationTimeUs;
        this.size = _size;
        this.flags = _flags;
        this.resize(_size);
        if (buffer != null && _size > _offset) {
            buffer.position(_offset + _size);
            buffer.flip();
            buffer.position(_offset);
            this.mBuffer.put(buffer);
            this.mBuffer.flip();
        }
    }

    @TargetApi(value=16)
    public void set(@Nullable ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) {
        this.presentationTimeUs = info.presentationTimeUs;
        this.size = buffer != null ? info.size : 0;
        this.flags = info.flags;
        int offset = info.offset;
        this.resize(this.size);
        if (buffer != null && this.size > offset) {
            buffer.position(offset + this.size);
            buffer.flip();
            buffer.position(offset);
            this.mBuffer.put(buffer);
            this.mBuffer.flip();
        }
    }

    public MediaData resize(@IntRange(from=0L) int newSize) {
        if (this.mBuffer == null || this.mBuffer.capacity() < newSize) {
            this.mBuffer = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
        }
        this.mBuffer.clear();
        return this;
    }

    public void clear() {
        this.flags = 0;
        this.size = 0;
        this.mBuffer.clear();
    }

    public int size() {
        return this.size;
    }

    public long presentationTimeUs() {
        return this.presentationTimeUs;
    }

    public void get(byte[] buffer) throws ArrayIndexOutOfBoundsException {
        if (buffer == null || buffer.length < this.size) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        this.mBuffer.clear();
        this.mBuffer.position(this.size);
        this.mBuffer.flip();
        this.mBuffer.get(buffer);
    }

    public void get(ByteBuffer buffer) throws ArrayIndexOutOfBoundsException {
        if (buffer == null || buffer.remaining() < this.size) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        this.mBuffer.clear();
        this.mBuffer.position(this.size);
        this.mBuffer.flip();
        buffer.put(this.mBuffer);
    }

    @TargetApi(value=16)
    public void get(@NonNull MediaCodec.BufferInfo info) {
        info.set(0, this.size, this.presentationTimeUs, this.flags);
    }

    public ByteBuffer get() {
        this.mBuffer.clear();
        this.mBuffer.position(this.size);
        this.mBuffer.flip();
        return this.mBuffer;
    }
}

