/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.jiangdg.media.Encoder;
import com.jiangdg.media.IMuxer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public interface IRecorder {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_STARTING = 3;
    public static final int STATE_STARTED = 4;
    public static final int STATE_STOPPING = 5;

    public void setMuxer(IMuxer var1);

    public void prepare();

    public void startRecording() throws IllegalStateException;

    public void stopRecording();

    public Surface getInputSurface();

    public Encoder getVideoEncoder();

    public Encoder getAudioEncoder();

    public boolean isStarted();

    public boolean isReady();

    public boolean isStopping();

    public boolean isStopped();

    public int getState();

    public IMuxer getMuxer();

    @Nullable
    public String getOutputPath();

    @Nullable
    public DocumentFile getOutputFile();

    public void frameAvailableSoon();

    public void release();

    public void addEncoder(Encoder var1);

    public void removeEncoder(Encoder var1);

    public boolean start(Encoder var1);

    public void stop(Encoder var1);

    public int addTrack(Encoder var1, MediaFormat var2);

    public void writeSampleData(int var1, ByteBuffer var2, MediaCodec.BufferInfo var3);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecorderState {
    }

    public static interface RecorderCallback {
        public void onPrepared(IRecorder var1);

        public void onStarted(IRecorder var1);

        public void onStopped(IRecorder var1);

        public void onError(Exception var1);
    }
}

