/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.math;

import android.opengl.Matrix;
import java.io.Serializable;
import java.util.Locale;

public class Vector
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1620440892067002860L;
    public static final float TO_RADIAN = (float)Math.PI / 180;
    public static final float TO_DEGREE = 57.29578f;
    public static final Vector zeroVector = new Vector();
    public static final Vector normVector = new Vector(1.0f, 1.0f, 1.0f);
    private static final float[] matrix = new float[16];
    private static final float[] inVec = new float[4];
    private static final float[] outVec = new float[4];
    public float x;
    public float y;
    public float z;

    public Vector() {
    }

    public Vector(float x, float y) {
        this(x, y, 0.0f);
    }

    public Vector(Vector v) {
        this(v.x, v.y, v.z);
    }

    public Vector(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Vector vector(float x, float y, float z) {
        return new Vector(x, y, z);
    }

    public static Vector vector(Vector v) {
        return new Vector(v.x, v.y, v.z);
    }

    public Vector clone() throws CloneNotSupportedException {
        Vector result = (Vector)super.clone();
        return result;
    }

    public Vector clear(float scalar) {
        this.y = this.z = scalar;
        this.x = this.z;
        return this;
    }

    public Vector set(float x, float y) {
        return this.set(x, y, 0.0f);
    }

    public Vector set(Vector v) {
        return this.set(v.x, v.y, v.z);
    }

    public Vector set(Vector v, float a) {
        return this.set(v.x, v.y, v.z, a);
    }

    public Vector set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector set(float x, float y, float z, float a) {
        this.x = x * a;
        this.y = y * a;
        this.z = z * a;
        return this;
    }

    public float x() {
        return this.x;
    }

    public void x(float x) {
        this.x = x;
    }

    public float y() {
        return this.y;
    }

    public void y(float y) {
        this.y = y;
    }

    public float z() {
        return this.z;
    }

    public void z(float z) {
        this.z = z;
    }

    public Vector add(float x, float y) {
        return this.add(x, y, 0.0f);
    }

    public Vector add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector add(float x, float y, float z, float a) {
        this.x += x * a;
        this.y += y * a;
        this.z += z * a;
        return this;
    }

    public Vector add(Vector v) {
        return this.add(v.x, v.y, v.z);
    }

    public Vector add(Vector v, float a) {
        return this.add(v.x, v.y, v.z, a);
    }

    public Vector sub(float x, float y) {
        return this.add(-x, -y, 0.0f);
    }

    public Vector sub(Vector v) {
        return this.add(-v.x, -v.y, -v.z);
    }

    public Vector sub(Vector v, float a) {
        return this.add(-v.x, -v.y, -v.z, a);
    }

    public Vector sub(float x, float y, float z) {
        return this.add(-x, -y, -z);
    }

    public Vector sub(float x, float y, float z, float a) {
        return this.add(-x, -y, -z, a);
    }

    public Vector mult(Vector other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
        return this;
    }

    public Vector mult(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Vector mult(float x_scale, float y_scale) {
        this.x *= x_scale;
        this.y *= y_scale;
        return this;
    }

    public Vector mult(float x_scale, float y_scale, float z_scale) {
        this.x *= x_scale;
        this.y *= y_scale;
        this.z *= z_scale;
        return this;
    }

    public Vector div(Vector other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
        return this;
    }

    public Vector div(float scale) {
        this.x /= scale;
        this.y /= scale;
        this.z /= scale;
        return this;
    }

    public Vector div(float x_scale, float y_scale) {
        this.x /= x_scale;
        this.y /= y_scale;
        return this;
    }

    public Vector div(float x_scale, float y_scale, float z_scale) {
        this.x /= x_scale;
        this.y /= y_scale;
        this.z /= z_scale;
        return this;
    }

    public Vector mod(float scalar) {
        this.x %= scalar;
        this.y %= scalar;
        this.z %= scalar;
        return this;
    }

    public Vector toRadian() {
        return this.mult((float)Math.PI / 180);
    }

    public Vector toDegree() {
        return this.mult(57.29578f);
    }

    public Vector limit(float scalar) {
        float f = this.x >= scalar ? scalar : (this.x = this.x < -scalar ? -scalar : this.x);
        float f2 = this.y >= scalar ? scalar : (this.y = this.y < -scalar ? -scalar : this.y);
        float f3 = this.z >= scalar ? scalar : (this.z = this.z < -scalar ? -scalar : this.z);
        while (this.x >= scalar) {
            this.x -= scalar;
        }
        while (this.x < -scalar) {
            this.x += scalar;
        }
        while (this.y >= scalar) {
            this.y -= scalar;
        }
        while (this.y < -scalar) {
            this.y += scalar;
        }
        while (this.z >= scalar) {
            this.z -= scalar;
        }
        while (this.z < -scalar) {
            this.z += scalar;
        }
        return this;
    }

    public Vector limit(float lower, float upper) {
        float f = this.x >= upper ? upper : (this.x = this.x < lower ? lower : this.x);
        float f2 = this.y >= upper ? upper : (this.y = this.y < lower ? lower : this.y);
        this.z = this.z >= upper ? upper : (this.z < lower ? lower : this.z);
        return this;
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lenSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector normalize() {
        float len = this.len();
        if (len != 0.0f) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
        return this;
    }

    public float dot(Vector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float dotProduct(Vector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float dotProduct(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float cross2(Vector v) {
        return this.x * v.y - v.x * this.y;
    }

    public float crossProduct2(Vector v) {
        return this.x * v.y - v.x * this.y;
    }

    public Vector cross(Vector v) {
        return Vector.crossProduct(this, this, v);
    }

    public Vector crossProduct(Vector v) {
        return Vector.crossProduct(this, this, v);
    }

    public static Vector cross(Vector v3, Vector v1, Vector v2) {
        float x3 = v1.y * v2.z - v1.z * v2.y;
        float y3 = v1.z * v2.x - v1.x * v2.z;
        float z3 = v1.x * v2.y - v1.y * v2.x;
        v3.x = x3;
        v3.y = y3;
        v3.z = z3;
        return v3;
    }

    public static Vector crossProduct(Vector v3, Vector v1, Vector v2) {
        float x3 = v1.y * v2.z - v1.z * v2.y;
        float y3 = v1.z * v2.x - v1.x * v2.z;
        float z3 = v1.x * v2.y - v1.y * v2.x;
        v3.x = x3;
        v3.y = y3;
        v3.z = z3;
        return v3;
    }

    public float angleXY() {
        float angle = (float)Math.atan2(this.y, this.x) * 57.29578f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float angleXZ() {
        float angle = (float)Math.atan2(this.z, this.x) * 57.29578f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float angleYZ() {
        float angle = (float)Math.atan2(this.z, this.y) * 57.29578f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getAngle(Vector v) {
        double cos = this.dotProduct(v) / (float)Math.sqrt(this.lenSquared() * v.lenSquared());
        return (float)Math.acos(cos) * 57.29578f;
    }

    public Vector rotateXY(float angle) {
        float rad = angle * ((float)Math.PI / 180);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float newX = this.x * cos - this.y * sin;
        float newY = this.x * sin + this.y * cos;
        this.x = newX;
        this.y = newY;
        return this;
    }

    public Vector rotateXZ(float angle) {
        float rad = angle * ((float)Math.PI / 180);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float newX = this.x * cos - this.z * sin;
        float newZ = this.x * sin + this.z * cos;
        this.x = newX;
        this.z = newZ;
        return this;
    }

    public Vector rotateYZ(float angle) {
        float rad = angle * ((float)Math.PI / 180);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float newY = this.y * cos - this.z * sin;
        float newZ = this.y * sin + this.z * cos;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vector rotate(float angle, float axisX, float axisY, float axisZ) {
        Vector.inVec[0] = this.x;
        Vector.inVec[1] = this.y;
        Vector.inVec[2] = this.z;
        Vector.inVec[3] = 1.0f;
        Matrix.setIdentityM((float[])matrix, (int)0);
        Matrix.rotateM((float[])matrix, (int)0, (float)angle, (float)axisX, (float)axisY, (float)axisZ);
        Matrix.multiplyMV((float[])outVec, (int)0, (float[])matrix, (int)0, (float[])inVec, (int)0);
        this.x = outVec[0];
        this.y = outVec[1];
        this.z = outVec[2];
        return this;
    }

    public Vector rotate(float angleX, float angleY, float angleZ) {
        return Vector.rotate(this, angleX, angleY, angleZ);
    }

    public static Vector rotate(Vector v, float angleX, float angleY, float angleZ) {
        Vector.inVec[0] = v.x;
        Vector.inVec[1] = v.y;
        Vector.inVec[2] = v.z;
        Vector.inVec[3] = 1.0f;
        Matrix.setIdentityM((float[])matrix, (int)0);
        if (angleX != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (angleY != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (angleZ != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Matrix.multiplyMV((float[])outVec, (int)0, (float[])matrix, (int)0, (float[])inVec, (int)0);
        v.x = outVec[0];
        v.y = outVec[1];
        v.z = outVec[2];
        return v;
    }

    public static Vector[] rotate(Vector[] v, float angleX, float angleY, float angleZ) {
        Matrix.setIdentityM((float[])matrix, (int)0);
        if (angleX != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (angleY != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (angleZ != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        int n = v != null ? v.length : 0;
        for (int i = 0; i < n; ++i) {
            if (v[i] == null) continue;
            Vector.inVec[0] = v[i].x;
            Vector.inVec[1] = v[i].y;
            Vector.inVec[2] = v[i].z;
            Vector.inVec[3] = 1.0f;
            Matrix.multiplyMV((float[])outVec, (int)0, (float[])matrix, (int)0, (float[])inVec, (int)0);
            v[i].x = outVec[0];
            v[i].y = outVec[1];
            v[i].z = outVec[2];
        }
        return v;
    }

    public Vector rotate(Vector angle, float a) {
        this.rotate(angle.x * a, angle.y * a, angle.z * a);
        return this;
    }

    public Vector rotate(Vector angle) {
        return this.rotate(angle.x, angle.y, angle.z);
    }

    public Vector rotate_inv(float angleX, float angleY, float angleZ) {
        Vector.inVec[0] = this.x;
        Vector.inVec[1] = this.y;
        Vector.inVec[2] = this.z;
        Vector.inVec[3] = 1.0f;
        Matrix.setIdentityM((float[])matrix, (int)0);
        if (angleZ != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (angleY != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (angleX != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        Matrix.multiplyMV((float[])outVec, (int)0, (float[])matrix, (int)0, (float[])inVec, (int)0);
        this.x = outVec[0];
        this.y = outVec[1];
        this.z = outVec[2];
        return this;
    }

    public Vector rotate_inv(Vector angle, float a) {
        this.rotate_inv(angle.x * a, angle.y * a, angle.z * a);
        return this;
    }

    public Vector rotate_inv(Vector angle) {
        this.rotate_inv(angle, -1.0f);
        return this;
    }

    public float[] getQuat() {
        float[] q = new float[]{this.x, this.y, this.z, 1.0f};
        return q;
    }

    public Vector setQuat(float[] q) {
        this.x = q[0];
        this.y = q[1];
        this.z = q[2];
        return this;
    }

    public float distance(Vector v) {
        return this.distance(v.x, v.y, v.z);
    }

    public float distance(float x, float y) {
        return this.distance(x, y, this.z);
    }

    public float distance(float x, float y, float z) {
        return (float)Math.sqrt(this.distSquared(x, y, z));
    }

    public float distSquared(Vector v) {
        return this.distSquared(v.x, v.y, v.z);
    }

    public float distSquared(float x, float y) {
        return this.distSquared(x, y, this.z);
    }

    public float distSquared(float x, float y, float z) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public Vector swap(Vector v) {
        float w = this.x;
        this.x = v.x;
        v.x = w;
        w = this.y;
        this.y = v.y;
        v.y = w;
        w = this.z;
        this.z = v.z;
        v.z = w;
        return this;
    }

    public Vector swapXY() {
        float w = this.x;
        this.x = this.y;
        this.y = w;
        return this;
    }

    public float slope(Vector v) {
        if (v.x != this.x) {
            return (v.y - this.y) / (v.x - this.x);
        }
        return v.y - this.y >= 0.0f ? Float.MAX_VALUE : Float.MIN_VALUE;
    }

    public float slope() {
        if (this.x != 0.0f) {
            return this.y / this.x;
        }
        return this.y >= 0.0f ? Float.MAX_VALUE : Float.MIN_VALUE;
    }

    public Vector sign() {
        this.x = Math.signum(this.x);
        this.y = Math.signum(this.y);
        this.z = Math.signum(this.z);
        return this;
    }

    public String toString() {
        return String.format(Locale.US, "(%f,%f,%f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public String toString(String fmt) {
        return String.format(Locale.US, fmt, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

