/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.math;

import com.jiangdg.math.Vector;
import java.io.Serializable;

public abstract class BaseBounds
implements Serializable {
    private static final long serialVersionUID = 5504958491886331189L;
    public final Vector position = new Vector();
    public final Vector angle = new Vector();
    public float radius;

    public BaseBounds() {
    }

    public BaseBounds(BaseBounds src) {
        this.set(src);
    }

    public BaseBounds(float center_x, float center_y, float radius) {
        this.position.set(center_x, center_y);
        this.radius = radius;
    }

    public BaseBounds(float center_x, float center_y, float center_z, float radius) {
        this.position.set(center_x, center_y, center_z);
        this.radius = radius;
    }

    public BaseBounds set(BaseBounds src) {
        this.position.set(src.position);
        this.angle.set(src.angle);
        this.radius = src.radius;
        return this;
    }

    protected boolean ptInBoundsSphere(float x, float y, float z, float r) {
        return this.position.distSquared(x, y, z) < r * r;
    }

    public boolean ptInBounds(float x, float y) {
        return this.ptInBounds(x, y, this.position.z);
    }

    public boolean ptInBounds(Vector other) {
        return this.ptInBounds(other.x, other.y, other.z);
    }

    public abstract boolean ptInBounds(float var1, float var2, float var3);

    public BaseBounds move(float offset_x, float offset_y) {
        this.position.add(offset_x, offset_y);
        return this;
    }

    public BaseBounds move(float offset_x, float offset_y, float offset_z) {
        this.position.add(offset_x, offset_y, offset_z);
        return this;
    }

    public BaseBounds move(Vector offset) {
        this.position.add(offset);
        return this;
    }

    public BaseBounds setPosition(Vector pos) {
        this.position.set(pos);
        return this;
    }

    public BaseBounds setPosition(float x, float y) {
        this.position.set(x, y);
        return this;
    }

    public BaseBounds setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
        return this;
    }

    public void centerX(float x) {
        this.position.x = x;
    }

    public float centerX() {
        return this.position.x;
    }

    public void centerY(float y) {
        this.position.y = y;
    }

    public float centerY() {
        return this.position.y;
    }

    public void centerZ(float z) {
        this.position.z = z;
    }

    public float centerZ() {
        return this.position.z;
    }

    public void rotate(Vector angle) {
        angle.set(angle.x, angle.y, angle.z);
    }

    public void rotate(float x, float y, float z) {
        this.angle.set(x, y, z);
    }

    public void rotateX(float angle) {
        this.angle.x = angle;
    }

    public void rotateY(float angle) {
        this.angle.y = angle;
    }

    public void rotateZ(float angle) {
        this.angle.z = angle;
    }
}

