/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.io;

import androidx.annotation.NonNull;
import com.jiangdg.io.IReadable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ReadableInputStreamWrapper
extends InputStream
implements IReadable {
    private final InputStream mParent;

    public ReadableInputStreamWrapper(InputStream parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.mParent = parent;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        byte[] b = new byte[dst.remaining()];
        int readBytes = this.mParent.read(b);
        dst.put(b, 0, readBytes);
        return readBytes;
    }

    @Override
    public int read() throws IOException {
        return this.mParent.read();
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        return this.mParent.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.mParent.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.mParent.available();
    }

    @Override
    public void close() throws IOException {
        this.mParent.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mParent.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mParent.reset();
    }

    @Override
    public boolean markSupported() {
        return this.mParent.markSupported();
    }
}

